/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProvider;
import org.keycloak.connections.jpa.entityprovider.ProxyClassLoader;
import org.keycloak.models.KeycloakSession;

public class JpaUtils {
    public static final String HIBERNATE_DEFAULT_SCHEMA = "hibernate.default_schema";

    public static String getTableNameForNativeQuery(String tableName, EntityManager em) {
        String schema = (String)em.getEntityManagerFactory().getProperties().get(HIBERNATE_DEFAULT_SCHEMA);
        return schema == null ? tableName : schema + "." + tableName;
    }

    public static EntityManagerFactory createEntityManagerFactory(KeycloakSession session, String unitName, Map<String, Object> properties, ClassLoader classLoader) {
        PersistenceXmlParser parser = new PersistenceXmlParser((ClassLoaderService)new ClassLoaderServiceImpl(classLoader), PersistenceUnitTransactionType.RESOURCE_LOCAL);
        List persistenceUnits = parser.doResolve(properties);
        for (ParsedPersistenceXmlDescriptor persistenceUnit : persistenceUnits) {
            if (!persistenceUnit.getName().equals(unitName)) continue;
            List<Class<?>> providedEntities = JpaUtils.getProvidedEntities(session);
            for (Class<?> entityClass : providedEntities) {
                persistenceUnit.addClasses(new String[]{entityClass.getName()});
            }
            return Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)persistenceUnit, properties, (ClassLoader)new ProxyClassLoader(providedEntities, classLoader)).build();
        }
        throw new RuntimeException("Persistence unit '" + unitName + "' not found");
    }

    public static List<Class<?>> getProvidedEntities(KeycloakSession session) {
        ArrayList providedEntityClasses = new ArrayList();
        Set entityProviders = session.getAllProviders(JpaEntityProvider.class);
        for (JpaEntityProvider entityProvider : entityProviders) {
            providedEntityClasses.addAll(entityProvider.getEntities());
        }
        return providedEntityClasses;
    }

    public static String getCustomChangelogTableName(String jpaEntityProviderFactoryId) {
        String upperCased = jpaEntityProviderFactoryId.toUpperCase();
        upperCased = upperCased.replaceAll("-", "_");
        upperCased = upperCased.replaceAll("[^A-Z_]", "");
        return "DATABASECHANGELOG_" + upperCased.substring(0, Math.min(10, upperCased.length()));
    }
}

