/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import [Ljava.lang.String;;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import org.apache.tools.ant.types.Commandline;

public class SunRmic
extends DefaultRmicAdapter {
    public static final String RMIC_CLASSNAME = "sun.rmi.rmic.Main";
    public static final String COMPILER_NAME = "sun";
    public static final String RMIC_EXECUTABLE = "rmic";
    public static final String ERROR_NO_RMIC_ON_CLASSPATH = "Cannot use SUN rmic, as it is not available.  A common solution is to set the environment variable JAVA_HOME";
    public static final String ERROR_RMIC_FAILED = "Error starting SUN rmic: ";

    public boolean execute() throws BuildException {
        this.getRmic().log("Using SUN rmic compiler", 3);
        Commandline cmd = this.setupRmicCommand();
        LogOutputStream logstr = new LogOutputStream(this.getRmic(), 1);
        try {
            Class<?> c = Class.forName(RMIC_CLASSNAME);
            Constructor<?> cons = c.getConstructor(OutputStream.class, String.class);
            Object rmic = cons.newInstance(logstr, RMIC_EXECUTABLE);
            Method doRmic = c.getMethod("compile", String;.class);
            Boolean ok = (Boolean)doRmic.invoke(rmic, new Object[]{cmd.getArguments()});
            boolean bl = ok;
            return bl;
        }
        catch (ClassNotFoundException ex) {
            throw new BuildException(ERROR_NO_RMIC_ON_CLASSPATH, this.getRmic().getLocation());
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException(ERROR_RMIC_FAILED, ex, this.getRmic().getLocation());
        }
        finally {
            try {
                logstr.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
    }

    protected String[] preprocessCompilerArgs(String[] compilerArgs) {
        return this.filterJvmCompilerArgs(compilerArgs);
    }
}

