/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.PrioritizedComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.UserStorageProvider;

public class UserCredentialStoreManager
implements UserCredentialManager,
OnUserCache {
    protected KeycloakSession session;

    public UserCredentialStoreManager(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getStoreForUser(UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return (UserCredentialStore)this.session.userLocalStorage();
        }
        return (UserCredentialStore)this.session.userFederatedStorage();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.getStoreForUser(user).updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.getStoreForUser(user).createCredential(realm, user, cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).removeStoredCredential(realm, user, id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).getStoredCredentialById(realm, user, id);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.getStoreForUser(user).getStoredCredentials(realm, user);
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        return this.getStoreForUser(user).getStoredCredentialsByType(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoreForUser(user).getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean isValid(RealmModel realm, UserModel user, List<CredentialInput> inputs) {
        String providerId;
        UserStorageProvider provider;
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>();
        toValidate.addAll(inputs);
        if (!StorageId.isLocalStorage((UserModel)user) && (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputValidator) {
            Iterator it = toValidate.iterator();
            while (it.hasNext()) {
                CredentialInputValidator validator = (CredentialInputValidator)provider;
                CredentialInput input = (CredentialInput)it.next();
                if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
                it.remove();
            }
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        List<ComponentModel> components = this.getCredentialProviderComponents(realm);
        for (ComponentModel component : components) {
            CredentialProviderFactory factory = (CredentialProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(CredentialProvider.class, component.getProviderId());
            if (!Types.supports(CredentialInputValidator.class, (Object)factory, CredentialProviderFactory.class)) continue;
            Iterator it = toValidate.iterator();
            while (it.hasNext()) {
                CredentialInput input = (CredentialInput)it.next();
                CredentialInputValidator validator = (CredentialInputValidator)this.session.getAttribute(component.getId());
                if (validator == null) {
                    validator = (CredentialInputValidator)factory.create(this.session, component);
                    this.session.setAttribute(component.getId(), (Object)validator);
                }
                if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
                it.remove();
            }
        }
        return toValidate.isEmpty();
    }

    protected List<ComponentModel> getCredentialProviderComponents(RealmModel realm) {
        List components = realm.getComponents(realm.getId(), CredentialProvider.class.getName());
        if (components.isEmpty()) {
            return components;
        }
        LinkedList<ComponentModel> copy = new LinkedList<ComponentModel>();
        copy.addAll(components);
        Collections.sort(copy, PrioritizedComponentModel.comparator);
        return copy;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        CredentialInputUpdater updater;
        String providerId;
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user) && (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputUpdater && (updater = (CredentialInputUpdater)provider).supportsCredentialType(input.getType()) && updater.updateCredential(realm, user, input)) {
            return;
        }
        List<ComponentModel> components = this.getCredentialProviderComponents(realm);
        for (ComponentModel component : components) {
            CredentialProviderFactory factory = (CredentialProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(CredentialProvider.class, component.getProviderId());
            if (!Types.supports(CredentialInputUpdater.class, (Object)factory, CredentialProviderFactory.class)) continue;
            CredentialInputUpdater updater2 = (CredentialInputUpdater)this.session.getAttribute(component.getId());
            if (updater2 == null) {
                updater2 = (CredentialInputUpdater)factory.create(this.session, component);
                this.session.setAttribute(component.getId(), (Object)updater2);
            }
            if (!updater2.supportsCredentialType(input.getType()) || !updater2.updateCredential(realm, user, input)) continue;
            return;
        }
    }

    public void disableCredential(RealmModel realm, UserModel user, String credentialType) {
        CredentialInputUpdater updater;
        String providerId;
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user) && (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputUpdater && (updater = (CredentialInputUpdater)provider).supportsCredentialType(credentialType)) {
            updater.disableCredentialType(realm, user, credentialType);
        }
        List<ComponentModel> components = this.getCredentialProviderComponents(realm);
        for (ComponentModel component : components) {
            CredentialProviderFactory factory = (CredentialProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(CredentialProvider.class, component.getProviderId());
            if (!Types.supports(CredentialInputUpdater.class, (Object)factory, CredentialProviderFactory.class)) continue;
            CredentialInputUpdater updater2 = (CredentialInputUpdater)this.session.getAttribute(component.getId());
            if (updater2 == null) {
                updater2 = (CredentialInputUpdater)factory.create(this.session, component);
                this.session.setAttribute(component.getId(), (Object)updater2);
            }
            if (!updater2.supportsCredentialType(credentialType)) continue;
            updater2.disableCredentialType(realm, user, credentialType);
        }
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String type) {
        CredentialInputValidator validator;
        String providerId;
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user) && (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputValidator && (validator = (CredentialInputValidator)provider).supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type)) {
            return true;
        }
        List<ComponentModel> components = this.getCredentialProviderComponents(realm);
        for (ComponentModel component : components) {
            CredentialProviderFactory factory = (CredentialProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(CredentialProvider.class, component.getProviderId());
            if (!Types.supports(CredentialInputUpdater.class, (Object)factory, CredentialProviderFactory.class)) continue;
            CredentialInputValidator validator2 = (CredentialInputValidator)this.session.getAttribute(component.getId());
            if (validator2 == null) {
                validator2 = (CredentialInputValidator)factory.create(this.session, component);
                this.session.setAttribute(component.getId(), (Object)validator2);
            }
            if (!validator2.supportsCredentialType(type) || !validator2.isConfiguredFor(realm, user, type)) continue;
            return true;
        }
        return false;
    }

    public void onCache(RealmModel realm, CachedUserModel user) {
        List<ComponentModel> components = this.getCredentialProviderComponents(realm);
        for (ComponentModel component : components) {
            CredentialProviderFactory factory = (CredentialProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(CredentialProvider.class, component.getProviderId());
            if (!Types.supports(OnUserCache.class, (Object)factory, CredentialProviderFactory.class)) continue;
            OnUserCache validator = (OnUserCache)this.session.getAttribute(component.getId());
            if (validator == null) {
                validator = (OnUserCache)factory.create(this.session, component);
                this.session.setAttribute(component.getId(), (Object)validator);
            }
            validator.onCache(realm, user);
        }
    }

    public void close() {
    }
}

