/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.hash;

import org.jboss.logging.Logger;
import org.keycloak.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialValueModel;

public class PasswordHashManager {
    private static final Logger log = Logger.getLogger(PasswordHashManager.class);

    public static UserCredentialValueModel encode(KeycloakSession session, RealmModel realm, String rawPassword) {
        return PasswordHashManager.encode(session, realm.getPasswordPolicy(), rawPassword);
    }

    public static UserCredentialValueModel encode(KeycloakSession session, PasswordPolicy passwordPolicy, String rawPassword) {
        PasswordHashProvider provider = session.getProvider(PasswordHashProvider.class, passwordPolicy.getHashAlgorithm());
        if (provider == null) {
            log.warnv("Could not find hash provider {0} from password policy, using default provider {1}", (Object)passwordPolicy.getHashAlgorithm(), (Object)"pbkdf2");
            provider = session.getProvider(PasswordHashProvider.class, "pbkdf2");
        }
        return provider.encode(rawPassword, passwordPolicy.getHashIterations());
    }

    public static boolean verify(KeycloakSession session, RealmModel realm, String password, UserCredentialValueModel credential) {
        return PasswordHashManager.verify(session, realm.getPasswordPolicy(), password, credential);
    }

    public static boolean verify(KeycloakSession session, PasswordPolicy passwordPolicy, String password, UserCredentialValueModel credential) {
        String algorithm = credential.getAlgorithm() != null ? credential.getAlgorithm() : passwordPolicy.getHashAlgorithm();
        PasswordHashProvider provider = session.getProvider(PasswordHashProvider.class, algorithm);
        if (provider == null) {
            log.warnv("Could not find hash provider {0} for password", (Object)algorithm);
            return false;
        }
        return provider.verify(password, credential);
    }
}

