/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.api;

import cx.ath.matthew.LibraryLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.freedesktop.sssd.infopipe.User;
import org.jboss.logging.Logger;

public class Sssd {
    private String username;
    private static final Logger logger = Logger.getLogger(Sssd.class);

    public static User user() {
        return SingletonHolder.USER_OBJECT;
    }

    public static InfoPipe infopipe() {
        return SingletonHolder.INFOPIPE_OBJECT;
    }

    public static void disconnect() {
        SingletonHolder.DBUS_CONNECTION.disconnect();
    }

    private Sssd() {
    }

    public Sssd(String username) {
        this.username = username;
    }

    public static String getRawAttribute(Variant variant) {
        Vector value;
        if (variant != null && (value = (Vector)variant.getValue()).size() >= 1) {
            return value.get(0).toString();
        }
        return null;
    }

    public Map<String, Variant> getUserAttributes() {
        String[] attr = new String[]{"mail", "givenname", "sn", "telephoneNumber"};
        Map<String, Variant> attributes = null;
        try {
            InfoPipe infoPipe = Sssd.infopipe();
            attributes = infoPipe.getUserAttributes(this.username, Arrays.asList(attr));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve user's attributes from SSSD", (Throwable)e);
        }
        return attributes;
    }

    public List<String> getUserGroups() {
        List<String> userGroups = null;
        try {
            InfoPipe infoPipe = Sssd.infopipe();
            userGroups = infoPipe.getUserGroups(this.username);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve user's groups from SSSD", (Throwable)e);
        }
        return userGroups;
    }

    public static boolean isAvailable() {
        boolean sssdAvailable = false;
        try {
            if (LibraryLoader.load().succeed()) {
                DBusConnection connection = DBusConnection.getConnection(0);
                DBus dbus = connection.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
                sssdAvailable = Arrays.asList(dbus.ListNames()).contains("org.freedesktop.sssd.infopipe");
                if (!sssdAvailable) {
                    logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", new Object[0]);
                } else {
                    sssdAvailable = true;
                }
                connection.disconnect();
            } else {
                logger.debugv("libunix_dbus_java not found. Federation provider will be disabled.", new Object[0]);
            }
        }
        catch (DBusException e) {
            logger.error((Object)"Failed to check the status of SSSD", (Throwable)e);
        }
        return sssdAvailable;
    }

    private static final class SingletonHolder {
        private static InfoPipe INFOPIPE_OBJECT;
        private static User USER_OBJECT;
        private static DBusConnection DBUS_CONNECTION;

        private SingletonHolder() {
        }

        static {
            try {
                DBUS_CONNECTION = DBusConnection.getConnection(0);
                INFOPIPE_OBJECT = DBUS_CONNECTION.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
                USER_OBJECT = DBUS_CONNECTION.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe/Users", User.class);
            }
            catch (DBusException e) {
                logger.error((Object)"Failed to obtain D-Bus connection", (Throwable)e);
            }
        }
    }
}

