/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.util.Map;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.protocol.oidc.utils.JWKSUtils;
import org.keycloak.services.ServicesLogger;
import org.keycloak.util.JsonSerialization;

public class OIDCIdentityProviderFactory
extends AbstractIdentityProviderFactory<OIDCIdentityProvider> {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    public static final String PROVIDER_ID = "oidc";

    public String getName() {
        return "OpenID Connect v1.0";
    }

    public OIDCIdentityProvider create(IdentityProviderModel model) {
        return new OIDCIdentityProvider(new OIDCIdentityProviderConfig(model));
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> parseConfig(KeycloakSession session, InputStream inputStream) {
        return OIDCIdentityProviderFactory.parseOIDCConfig(session, inputStream);
    }

    protected static Map<String, String> parseOIDCConfig(KeycloakSession session, InputStream inputStream) {
        OIDCConfigurationRepresentation rep;
        try {
            rep = (OIDCConfigurationRepresentation)JsonSerialization.readValue((InputStream)inputStream, OIDCConfigurationRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load openid connect metadata", e);
        }
        OIDCIdentityProviderConfig config = new OIDCIdentityProviderConfig(new IdentityProviderModel());
        config.setIssuer(rep.getIssuer());
        config.setLogoutUrl(rep.getLogoutEndpoint());
        config.setAuthorizationUrl(rep.getAuthorizationEndpoint());
        config.setTokenUrl(rep.getTokenEndpoint());
        config.setUserInfoUrl(rep.getUserinfoEndpoint());
        if (rep.getJwksUri() != null) {
            OIDCIdentityProviderFactory.sendJwksRequest(session, rep, config);
        }
        return config.getConfig();
    }

    protected static void sendJwksRequest(KeycloakSession session, OIDCConfigurationRepresentation rep, OIDCIdentityProviderConfig config) {
        try {
            JSONWebKeySet keySet = JWKSUtils.sendJwksRequest(session, rep.getJwksUri());
            PublicKey key = JWKSUtils.getKeyForUse(keySet, JWK.Use.SIG);
            if (key == null) {
                logger.supportedJwkNotFound(JWK.Use.SIG.asString());
            } else {
                config.setPublicKeySignatureVerifier(KeycloakModelUtils.getPemFromKey((Key)key));
                config.setValidateSignature(true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to query JWKSet from: " + rep.getJwksUri(), e);
        }
    }
}

