/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;

public class CertificateInfoHelper {
    public static final String PRIVATE_KEY = "private.key";
    public static final String X509CERTIFICATE = "certificate";
    public static final String PUBLIC_KEY = "public.key";

    public static CertificateRepresentation getCertificateFromClient(ClientModel client, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + "." + PRIVATE_KEY;
        String certificateAttribute = attributePrefix + "." + X509CERTIFICATE;
        String publicKeyAttribute = attributePrefix + "." + PUBLIC_KEY;
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setCertificate(client.getAttribute(certificateAttribute));
        rep.setPublicKey(client.getAttribute(publicKeyAttribute));
        rep.setPrivateKey(client.getAttribute(privateKeyAttribute));
        return rep;
    }

    public static void updateClientModelCertificateInfo(ClientModel client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + "." + PRIVATE_KEY;
        String certificateAttribute = attributePrefix + "." + X509CERTIFICATE;
        String publicKeyAttribute = attributePrefix + "." + PUBLIC_KEY;
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
    }

    private static void setOrRemoveAttr(ClientModel client, String attrName, String attrValue) {
        if (attrValue != null) {
            client.setAttribute(attrName, attrValue);
        } else {
            client.removeAttribute(attrName);
        }
    }

    public static PublicKey getSignatureValidationKey(ClientModel client, String attributePrefix) throws ModelException {
        CertificateRepresentation certInfo = CertificateInfoHelper.getCertificateFromClient(client, attributePrefix);
        String encodedCertificate = certInfo.getCertificate();
        String encodedPublicKey = certInfo.getPublicKey();
        if (encodedCertificate == null && encodedPublicKey == null) {
            throw new ModelException("Client doesn't have certificate or publicKey configured");
        }
        if (encodedCertificate != null && encodedPublicKey != null) {
            throw new ModelException("Client has both publicKey and certificate configured");
        }
        if (encodedCertificate != null) {
            X509Certificate clientCert = KeycloakModelUtils.getCertificate((String)encodedCertificate);
            return clientCert.getPublicKey();
        }
        return KeycloakModelUtils.getPublicKey((String)encodedPublicKey);
    }

    public static void updateClientRepresentationCertificateInfo(ClientRepresentation client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + "." + PRIVATE_KEY;
        String certificateAttribute = attributePrefix + "." + X509CERTIFICATE;
        String publicKeyAttribute = attributePrefix + "." + PUBLIC_KEY;
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
    }

    private static void setOrRemoveAttr(ClientRepresentation client, String attrName, String attrValue) {
        if (attrValue != null) {
            if (client.getAttributes() == null) {
                client.setAttributes(new HashMap());
            }
            client.getAttributes().put(attrName, attrValue);
        } else if (client.getAttributes() != null) {
            client.getAttributes().remove(attrName);
        }
    }
}

