/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.provider.ProviderEvent;

public interface UserModel
extends RoleMapperModel {
    public static final String USERNAME = "username";
    public static final String LAST_NAME = "lastName";
    public static final String FIRST_NAME = "firstName";
    public static final String EMAIL = "email";
    public static final String LOCALE = "locale";

    public String getId();

    public String getUsername();

    public void setUsername(String var1);

    public Long getCreatedTimestamp();

    public void setCreatedTimestamp(Long var1);

    public boolean isEnabled();

    public boolean isOtpEnabled();

    public void setEnabled(boolean var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public List<String> getAttribute(String var1);

    public Map<String, List<String>> getAttributes();

    public Set<String> getRequiredActions();

    public void addRequiredAction(String var1);

    public void removeRequiredAction(String var1);

    public void addRequiredAction(RequiredAction var1);

    public void removeRequiredAction(RequiredAction var1);

    public String getFirstName();

    public void setFirstName(String var1);

    public String getLastName();

    public void setLastName(String var1);

    public String getEmail();

    public void setEmail(String var1);

    public boolean isEmailVerified();

    public void setEmailVerified(boolean var1);

    public void setOtpEnabled(boolean var1);

    public void updateCredential(UserCredentialModel var1);

    public List<UserCredentialValueModel> getCredentialsDirectly();

    public void updateCredentialDirectly(UserCredentialValueModel var1);

    public Set<GroupModel> getGroups();

    public void joinGroup(GroupModel var1);

    public void leaveGroup(GroupModel var1);

    public boolean isMemberOf(GroupModel var1);

    public String getFederationLink();

    public void setFederationLink(String var1);

    public String getServiceAccountClientLink();

    public void setServiceAccountClientLink(String var1);

    public static enum RequiredAction {
        VERIFY_EMAIL,
        UPDATE_PROFILE,
        CONFIGURE_TOTP,
        UPDATE_PASSWORD;

    }

    public static interface UserRemovedEvent
    extends ProviderEvent {
        public UserModel getUser();

        public KeycloakSession getKeycloakSession();
    }
}

