/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.ClientQuery;

public class ClientListQuery
extends AbstractRevisioned
implements ClientQuery {
    private final Set<String> clients;
    private final String realm;
    private final String realmName;

    public ClientListQuery(Long revisioned, String id, RealmModel realm, Set<String> clients) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.clients = clients;
    }

    public ClientListQuery(Long revisioned, String id, RealmModel realm, String client) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.clients = new HashSet<String>();
        this.clients.add(client);
    }

    @Override
    public Set<String> getClients() {
        return this.clients;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        return "ClientListQuery{id='" + this.getId() + "'" + "realmName='" + this.realmName + '\'' + '}';
    }
}

