/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.provider.Provider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.user.UserCredentialAuthenticationProvider;
import org.keycloak.storage.user.UserCredentialValidatorProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class UserStorageManager
implements UserProvider,
OnUserCache {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);
    protected KeycloakSession session;

    public UserStorageManager(KeycloakSession session) {
        this.session = session;
    }

    protected UserProvider localStorage() {
        return this.session.userLocalStorage();
    }

    public static List<UserStorageProviderModel> getStorageProviders(RealmModel realm) {
        return realm.getUserStorageProviders();
    }

    public static <T> T getFirstStorageProvider(KeycloakSession session, RealmModel realm, Class<T> type) {
        for (UserStorageProviderModel model : UserStorageManager.getStorageProviders(realm)) {
            UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            return type.cast(UserStorageManager.getStorageProviderInstance(session, model, factory));
        }
        return null;
    }

    public static UserStorageProvider getStorageProviderInstance(KeycloakSession session, UserStorageProviderModel model, UserStorageProviderFactory factory) {
        UserStorageProvider instance = (UserStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> List<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (UserStorageProviderModel model : UserStorageManager.getStorageProviders(realm)) {
            UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            list.add(type.cast(UserStorageManager.getStorageProviderInstance(session, model, factory)));
        }
        return list;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserRegistrationProvider registry = UserStorageManager.getFirstStorageProvider(this.session, realm, UserRegistrationProvider.class);
        if (registry != null) {
            return registry.addUser(realm, username);
        }
        return this.localStorage().addUser(realm, username.toLowerCase());
    }

    public static UserStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find UserStorageProviderFactory for: " + model.getProviderId());
        }
        return UserStorageManager.getStorageProviderInstance(session, new UserStorageProviderModel(model), factory);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        StorageId storageId;
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, user);
        }
        if ((storageId = new StorageId(user.getId())).getProviderId() == null) {
            return this.localStorage().removeUser(realm, user);
        }
        UserRegistrationProvider registry = (UserRegistrationProvider)UserStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (registry == null) {
            throw new ModelException("Could not resolve StorageProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user, socialLink);
        }
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage((UserModel)federatedUser)) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        }
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().removeFederatedIdentity(realm, user, socialProvider);
        }
        return this.getFederatedStorage().removeFederatedIdentity(realm, user, socialProvider);
    }

    public void addConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().addConsent(realm, user, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, user, consent);
        }
    }

    public UserConsentModel getConsentByClient(RealmModel realm, UserModel user, String clientInternalId) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().getConsentByClient(realm, user, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, user, clientInternalId);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().getConsents(realm, user);
        }
        return this.getFederatedStorage().getConsents(realm, user);
    }

    public void updateConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().updateConsent(realm, user, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, user, consent);
        }
    }

    public boolean revokeConsentForClient(RealmModel realm, UserModel user, String clientInternalId) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().revokeConsentForClient(realm, user, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, user, clientInternalId);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.localStorage().getUserById(id, realm);
        }
        UserLookupProvider provider = (UserLookupProvider)UserStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        return provider.getUserById(id, realm);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.localStorage().getUserByUsername(username, realm);
        if (user != null) {
            return user;
        }
        for (UserLookupProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserLookupProvider.class)) {
            user = provider.getUserByUsername(username, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.localStorage().getUserByEmail(email, realm);
        if (user != null) {
            return user;
        }
        for (UserLookupProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserLookupProvider.class)) {
            user = provider.getUserByEmail(email, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(socialLink, realm);
        if (user != null) {
            return user;
        }
        if (this.getFederatedStorage() == null) {
            return null;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(id, realm);
        }
        return null;
    }

    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, 0, 0x7FFFFFFE, includeServiceAccounts);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public int getUsersCount(RealmModel realm) {
        int size = this.localStorage().getUsersCount(realm);
        for (UserQueryProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserQueryProvider.class)) {
            size += provider.getUsersCount(realm);
        }
        return size;
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        if (maxResults == 0) {
            return Collections.EMPTY_LIST;
        }
        List<UserQueryProvider> storageProviders = UserStorageManager.getStorageProviders(this.session, realm, UserQueryProvider.class);
        if (storageProviders.isEmpty()) {
            return pagedQuery.query(this.localStorage(), firstResult, maxResults);
        }
        LinkedList<Object> providers = new LinkedList<Object>();
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        if (this.getFederatedStorage() != null) {
            providers.add(this.getFederatedStorage());
        }
        int leftToRead = maxResults;
        int leftToFirstResult = firstResult;
        Iterator it = providers.iterator();
        while (it.hasNext() && leftToRead != 0) {
            Object provider = it.next();
            boolean exhausted = false;
            int index = 0;
            if (leftToFirstResult > 0) {
                do {
                    int toRead = Math.min(50, leftToFirstResult);
                    List<UserModel> tmp = pagedQuery.query(provider, index, toRead);
                    leftToFirstResult -= tmp.size();
                    index += tmp.size();
                    if (tmp.size() >= toRead) continue;
                    exhausted = true;
                    break;
                } while (leftToFirstResult > 0);
            }
            if (exhausted) continue;
            List<UserModel> tmp = pagedQuery.query(provider, index, leftToRead);
            results.addAll(tmp);
            if (leftToRead <= 0) continue;
            leftToRead -= tmp.size();
        }
        return results;
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserProvider) {
                return ((UserProvider)provider).getUsers(realm, first, max, includeServiceAccounts);
            }
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getUsers(realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUser(search, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUser(attributes, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUser(attributes, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserByUserAttribute(attrName, attrValue, realm);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List ids = ((UserFederatedStorageProvider)provider).getUsersByUserAttribute(realm, attrName, attrValue);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, 0, 0x7FFFFFFE);
        return results;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        if (StorageId.isLocalStorage((UserModel)user)) {
            set.addAll(this.localStorage().getFederatedIdentities(user, realm));
        }
        if (this.getFederatedStorage() != null) {
            set.addAll(this.getFederatedStorage().getFederatedIdentities(user, realm));
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage((UserModel)user) && (model = this.localStorage().getFederatedIdentity(user, socialProvider, realm)) != null) {
            return model;
        }
        if (this.getFederatedStorage() != null) {
            return this.getFederatedStorage().getFederatedIdentity(user, socialProvider, realm);
        }
        return null;
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        List<UserRegistrationProvider> storageProviders = UserStorageManager.getStorageProviders(this.session, realm, UserRegistrationProvider.class);
        LinkedList<Object> providers = new LinkedList<Object>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        for (UserRegistrationProvider userRegistrationProvider : providers) {
            userRegistrationProvider.grantToAllUsers(realm, role);
        }
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getGroupMembers(realm, group, first, max);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List ids = ((UserFederatedStorageProvider)provider).getMembership(realm, group, first, max);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return results;
    }

    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm);
            for (UserStorageProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm);
            }
        }
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel model) {
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, model);
        }
        this.localStorage().preRemove(realm, model);
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, group);
            for (UserStorageProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm, group);
            }
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, role);
            for (UserStorageProvider provider : UserStorageManager.getStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm, role);
            }
        }
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, client);
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(protocolMapper);
        }
    }

    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().validCredentials(session, realm, user, input);
        }
        List userCreds = user.getCredentialsDirectly();
        LinkedList<UserCredentialModel> toValidate = new LinkedList<UserCredentialModel>();
        toValidate.addAll(input);
        Iterator it = toValidate.iterator();
        boolean failedStoredCredential = false;
        while (it.hasNext()) {
            UserCredentialModel cred = (UserCredentialModel)it.next();
            boolean credValidated = false;
            for (UserCredentialValueModel userCred : userCreds) {
                if (!userCred.getType().equals(cred.getType())) continue;
                if (CredentialValidation.validCredential((KeycloakSession)session, (RealmModel)realm, (UserModel)user, (UserCredentialModel)cred)) {
                    credValidated = true;
                    break;
                }
                failedStoredCredential = true;
            }
            if (credValidated) {
                it.remove();
                continue;
            }
            if (!failedStoredCredential) continue;
            return false;
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        UserStorageProvider provider = UserStorageManager.getStorageProvider(session, realm, StorageId.resolveProviderId((UserModel)user));
        if (!(provider instanceof UserCredentialValidatorProvider)) {
            return false;
        }
        return ((UserCredentialValidatorProvider)provider).validCredentials(session, realm, user, toValidate);
    }

    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(session, realm, user, Arrays.asList(input));
    }

    public CredentialValidationOutput validCredentials(KeycloakSession session, RealmModel realm, UserCredentialModel ... input) {
        List<UserCredentialAuthenticationProvider> providers = UserStorageManager.getStorageProviders(session, realm, UserCredentialAuthenticationProvider.class);
        if (providers.isEmpty()) {
            return CredentialValidationOutput.failed();
        }
        CredentialValidationOutput result = null;
        for (UserCredentialModel cred : input) {
            UserCredentialAuthenticationProvider providerSupportingCreds = null;
            for (UserCredentialAuthenticationProvider provider : providers) {
                if (!provider.getSupportedCredentialAuthenticationTypes().contains(cred.getType())) continue;
                providerSupportingCreds = provider;
                break;
            }
            if (providerSupportingCreds == null) {
                logger.warn((Object)("Don't have provider supporting credentials of type " + cred.getType()));
                return CredentialValidationOutput.failed();
            }
            logger.debug((Object)("Found provider [" + providerSupportingCreds + "] supporting credentials of type " + cred.getType()));
            CredentialValidationOutput currentResult = providerSupportingCreds.validCredential(session, realm, cred);
            result = result == null ? currentResult : result.merge(currentResult);
        }
        return result != null ? result : CredentialValidationOutput.failed();
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
    }

    public void onCache(RealmModel realm, CachedUserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            if (this.session.userLocalStorage() instanceof OnUserCache) {
                ((OnUserCache)this.session.userLocalStorage()).onCache(realm, user);
            }
        } else {
            UserStorageProvider provider = UserStorageManager.getStorageProvider(this.session, realm, StorageId.resolveProviderId((UserModel)user));
            if (provider != null && provider instanceof OnUserCache) {
                ((OnUserCache)provider).onCache(realm, user);
            }
        }
    }

    public void close() {
    }

    @FunctionalInterface
    static interface PaginatedQuery {
        public List<UserModel> query(Object var1, int var2, int var3);
    }
}

