/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.role.RolePolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.util.JsonSerialization;

public class RolePolicyProviderFactory
implements PolicyProviderFactory {
    public String getName() {
        return "Role-Based";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(Policy policy, AuthorizationProvider authorization) {
        return new RolePolicyProvider(policy, authorization);
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return null;
    }

    public PolicyProvider create(KeycloakSession session) {
        return new RolePolicyProvider();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RoleContainerModel.RoleRemovedEvent) {
                KeycloakSession keycloakSession = ((RoleContainerModel.RoleRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                PolicyStore policyStore = provider.getStoreFactory().getPolicyStore();
                RoleModel removedRole = ((RoleContainerModel.RoleRemovedEvent)event).getRole();
                policyStore.findByType(this.getId()).forEach(policy -> {
                    ArrayList roles = new ArrayList();
                    for (Map<String, Object> role : RolePolicyProviderFactory.getRoles(policy)) {
                        if (role.get("id").equals(removedRole.getId())) continue;
                        HashMap<String, Object> updated = new HashMap<String, Object>();
                        updated.put("id", role.get("id"));
                        Object required = role.get("required");
                        if (required != null) {
                            updated.put("required", required);
                        }
                        roles.add(updated);
                    }
                    try {
                        if (roles.isEmpty()) {
                            policyStore.findDependentPolicies(policy.getId()).forEach(dependentPolicy -> dependentPolicy.removeAssociatedPolicy(policy));
                            policyStore.delete(policy.getId());
                        } else {
                            Map config = policy.getConfig();
                            config.put("roles", JsonSerialization.writeValueAsString(roles));
                            policy.setConfig(config);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error while synchronizing roles with policy [" + policy.getName() + "].", e);
                    }
                });
            }
        });
    }

    public void close() {
    }

    public String getId() {
        return "role";
    }

    static Map<String, Object>[] getRoles(Policy policy) {
        String roles = (String)policy.getConfig().get("roles");
        if (roles != null) {
            try {
                return (Map[])JsonSerialization.readValue((byte[])roles.getBytes(), Map[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse roles [" + roles + "] from policy config [" + policy.getName() + ".", e);
            }
        }
        return new Map[0];
    }
}

