/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;

public class TimePolicyProvider
implements PolicyProvider {
    static String DEFAULT_DATE_PATTERN = "yyyy-MM-dd hh:mm:ss";
    private final Policy policy;
    private final SimpleDateFormat dateFormat;
    private final Date currentDate;

    public TimePolicyProvider(Policy policy) {
        this.policy = policy;
        this.dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        this.currentDate = new Date();
    }

    public void evaluate(Evaluation evaluation) {
        try {
            String notBefore = (String)this.policy.getConfig().get("nbf");
            if (notBefore != null && this.currentDate.before(this.dateFormat.parse(TimePolicyProvider.format(notBefore)))) {
                evaluation.deny();
                return;
            }
            String notOnOrAfter = (String)this.policy.getConfig().get("noa");
            if (notOnOrAfter != null && this.currentDate.after(this.dateFormat.parse(TimePolicyProvider.format(notOnOrAfter)))) {
                evaluation.deny();
                return;
            }
            if (this.isInvalid(5, "dayMonth") || this.isInvalid(2, "month") || this.isInvalid(1, "year") || this.isInvalid(11, "hour") || this.isInvalid(12, "minute")) {
                evaluation.deny();
                return;
            }
            evaluation.grant();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not evaluate time-based policy [" + this.policy.getName() + "].", e);
        }
    }

    private boolean isInvalid(int timeConstant, String configName) {
        String end;
        String start;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.currentDate);
        int dateField = calendar.get(timeConstant);
        if (2 == timeConstant) {
            ++dateField;
        }
        return (start = (String)this.policy.getConfig().get(configName)) != null && ((end = (String)this.policy.getConfig().get(configName + "End")) != null ? dateField < Integer.parseInt(start) || dateField > Integer.parseInt(end) : dateField != Integer.parseInt(start));
    }

    static String format(String notBefore) {
        String trimmed = notBefore.trim();
        if (trimmed.length() == 10) {
            notBefore = trimmed + " 00:00:00";
        }
        return notBefore;
    }

    public void close() {
    }
}

