/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class NotUsernamePasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordNotUsernameMessage";
    private KeycloakContext context;

    public NotUsernamePasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    @Override
    public PolicyError validate(String username, String password) {
        if (username == null) {
            return null;
        }
        return username.equals(password) ? new PolicyError(ERROR_MESSAGE, new Object[0]) : null;
    }

    @Override
    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    @Override
    public Object parseConfig(String value) {
        return null;
    }

    @Override
    public void close() {
    }
}

