/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.mongo.store.MongoPolicyStore;
import org.keycloak.authorization.mongo.store.MongoResourceServerStore;
import org.keycloak.authorization.mongo.store.MongoResourceStore;
import org.keycloak.authorization.mongo.store.MongoScopeStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;

public class MongoStoreFactory
implements StoreFactory {
    private final MongoStoreInvocationContext invocationContext;
    private final AuthorizationProvider authorizationProvider;

    public MongoStoreFactory(MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        this.invocationContext = invocationContext;
        this.authorizationProvider = authorizationProvider;
    }

    public PolicyStore getPolicyStore() {
        return new MongoPolicyStore(this.invocationContext, this.authorizationProvider);
    }

    public ResourceServerStore getResourceServerStore() {
        return new MongoResourceServerStore(this.invocationContext, this.authorizationProvider);
    }

    public ResourceStore getResourceStore() {
        return new MongoResourceStore(this.invocationContext, this.authorizationProvider);
    }

    public ScopeStore getScopeStore() {
        return new MongoScopeStore(this.invocationContext, this.authorizationProvider);
    }

    public void close() {
    }
}

