/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.jvnet.libpam.impl.CLibrary;
import org.jvnet.libpam.impl.PAMLibrary;

public class PAM {
    private PAMLibrary.pam_handle_t pht;
    private int ret;
    private String[] factors;
    private static final Logger LOGGER = Logger.getLogger((String)PAM.class.getName());

    public PAM(String serviceName) throws PAMException {
        PAMLibrary.pam_conv conv = new PAMLibrary.pam_conv(new PAMLibrary.pam_conv.PamCallback(){

            @Override
            public int callback(int num_msg, Pointer msg, Pointer resp, Pointer _) {
                LOGGER.debug((Object)("pam_conv num_msg=" + num_msg));
                if (PAM.this.factors == null) {
                    return 6;
                }
                Pointer m = CLibrary.libc.calloc(PAMLibrary.pam_response.SIZE, num_msg);
                resp.setPointer(0L, m);
                for (int i = 0; i < PAM.this.factors.length; ++i) {
                    PAMLibrary.pam_message pm = new PAMLibrary.pam_message(msg.getPointer(Native.POINTER_SIZE * i));
                    LOGGER.debug((Object)(pm.msg_style + ":" + pm.msg));
                    if (pm.msg_style != 1) continue;
                    PAMLibrary.pam_response r = new PAMLibrary.pam_response(m.share(PAMLibrary.pam_response.SIZE * i));
                    r.setResp(PAM.this.factors[i]);
                    r.write();
                }
                return 0;
            }
        });
        PointerByReference phtr = new PointerByReference();
        this.check(PAMLibrary.libpam.pam_start(serviceName, null, conv, phtr), "pam_start failed");
        this.pht = new PAMLibrary.pam_handle_t(phtr.getValue());
    }

    private void check(int ret, String msg) throws PAMException {
        this.ret = ret;
        if (ret != 0) {
            if (this.pht != null) {
                throw new PAMException(msg + " : " + PAMLibrary.libpam.pam_strerror(this.pht, ret));
            }
            throw new PAMException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnixUser authenticate(String username, String ... factors) throws PAMException {
        this.factors = factors;
        try {
            this.check(PAMLibrary.libpam.pam_set_item(this.pht, 2, username), "pam_set_item failed");
            this.check(PAMLibrary.libpam.pam_authenticate(this.pht, 0), "pam_authenticate failed");
            this.check(PAMLibrary.libpam.pam_setcred(this.pht, 0), "pam_setcred failed");
            PointerByReference r = new PointerByReference();
            this.check(PAMLibrary.libpam.pam_get_item(this.pht, 2, r), "pam_get_item failed");
            String userName = r.getValue().getString(0L);
            CLibrary.passwd pwd = CLibrary.libc.getpwnam(userName);
            if (pwd == null) {
                throw new PAMException("Authentication succeeded but no user information is available");
            }
            UnixUser unixUser = new UnixUser(userName, pwd);
            return unixUser;
        }
        finally {
            this.factors = null;
        }
    }

    public Set<String> getGroupsOfUser(String username) throws PAMException {
        return new UnixUser(username).getGroups();
    }

    public void dispose() {
        if (this.pht != null) {
            PAMLibrary.libpam.pam_end(this.pht, this.ret);
            this.pht = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

