/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedScope;

public class CachedScopeStore
implements ScopeStore {
    private static final String SCOPE_ID_CACHE_PREFIX = "scp-id-";
    private final Cache<String, List> cache;
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private ScopeStore delegate;
    private StoreFactory storeFactory;

    public CachedScopeStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction) {
        this.session = session;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
    }

    public Scope create(String name, ResourceServer resourceServer) {
        Scope scope = this.getDelegate().create(name, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()));
        this.transaction.whenRollback(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForScope(scope.getId()));
        });
        return this.createAdapter(new CachedScope(scope));
    }

    public void delete(String id) {
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForScope(id));
        });
    }

    public Scope findById(String id) {
        String cacheKeyForScope = this.getCacheKeyForScope(id);
        List cached = (List)this.cache.get((Object)cacheKeyForScope);
        if (cached == null) {
            Scope scope = this.getDelegate().findById(id);
            if (scope != null) {
                return this.createAdapter(this.updateScopeCache(scope));
            }
            return null;
        }
        return this.createAdapter((CachedScope)cached.get(0));
    }

    public Scope findByName(String name, String resourceServerId) {
        for (Map.Entry entry : this.cache.entrySet()) {
            List cache;
            CachedScope scope;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(SCOPE_ID_CACHE_PREFIX) || !(scope = (CachedScope)(cache = (List)entry.getValue()).get(0)).getResourceServerId().equals(resourceServerId) || !scope.getName().equals(name)) continue;
            return this.findById(scope.getId());
        }
        Scope scope = this.getDelegate().findByName(name, resourceServerId);
        if (scope != null) {
            return this.findById(this.updateScopeCache(scope).getId());
        }
        return null;
    }

    public List<Scope> findByResourceServer(String id) {
        return this.getDelegate().findByResourceServer(id);
    }

    public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        return this.getDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
    }

    private String getCacheKeyForScope(String id) {
        return SCOPE_ID_CACHE_PREFIX + id;
    }

    private ScopeStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getScopeStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        if (this.storeFactory == null) {
            this.storeFactory = (StoreFactory)this.session.getProvider(StoreFactory.class);
        }
        return this.storeFactory;
    }

    private Scope createAdapter(final CachedScope cached) {
        return new Scope(){
            private Scope updated;

            public String getId() {
                return cached.getId();
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getIconUri() {
                return cached.getIconUri();
            }

            public void setIconUri(String iconUri) {
                this.getDelegateForUpdate().setIconUri(iconUri);
                cached.setIconUri(iconUri);
            }

            public ResourceServer getResourceServer() {
                return CachedScopeStore.this.getStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            private Scope getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedScopeStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedScopeStore.this.transaction.whenCommit(() -> {
                        List cfr_ignored_0 = (List)CachedScopeStore.this.cache.remove((Object)CachedScopeStore.this.getCacheKeyForScope(this.getId()));
                    });
                }
                return this.updated;
            }
        };
    }

    private CachedScope updateScopeCache(Scope scope) {
        CachedScope cached = new CachedScope(scope);
        ArrayList<CachedScope> cache = new ArrayList<CachedScope>();
        cache.add(cached);
        this.transaction.whenCommit(() -> {
            List cfr_ignored_0 = (List)this.cache.put((Object)this.getCacheKeyForScope(scope.getId()), (Object)cache);
        });
        return cached;
    }
}

