/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.security.PublicKey;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.RSATokenVerifier;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.services.util.P3PHelper;

public class AuthenticationManager {
    public static final String END_AFTER_REQUIRED_ACTIONS = "END_AFTER_REQUIRED_ACTIONS";
    public static final String AUTH_TIME = "AUTH_TIME";
    public static final String SSO_AUTH = "SSO_AUTH";
    protected static final Logger logger = Logger.getLogger(AuthenticationManager.class);
    public static final String FORM_USERNAME = "username";
    public static final String KEYCLOAK_IDENTITY_COOKIE = "KEYCLOAK_IDENTITY";
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final String KEYCLOAK_REMEMBER_ME = "KEYCLOAK_REMEMBER_ME";
    public static final String KEYCLOAK_LOGOUT_PROTOCOL = "KEYCLOAK_LOGOUT_PROTOCOL";
    public static final String CURRENT_REQUIRED_ACTION = "CURRENT_REQUIRED_ACTION";

    public static boolean isSessionValid(RealmModel realm, UserSessionModel userSession) {
        if (userSession == null) {
            logger.debug((Object)"No user session");
            return false;
        }
        int currentTime = Time.currentTime();
        int max = userSession.getStarted() + realm.getSsoSessionMaxLifespan();
        return userSession.getLastSessionRefresh() + realm.getSsoSessionIdleTimeout() > currentTime && max > currentTime;
    }

    public static void expireUserSessionCookie(KeycloakSession session, UserSessionModel userSession, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, ClientConnection connection) {
        try {
            Cookie cookie = (Cookie)headers.getCookies().get(KEYCLOAK_IDENTITY_COOKIE);
            if (cookie == null) {
                return;
            }
            String tokenString = cookie.getValue();
            RSATokenVerifier verifier = RSATokenVerifier.create((String)tokenString).realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(false).checkTokenType(false);
            String kid = verifier.getHeader().getKeyId();
            PublicKey publicKey = session.keys().getPublicKey(realm, kid);
            AccessToken token = verifier.publicKey(publicKey).verify().getToken();
            UserSessionModel cookieSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (cookieSession == null || !cookieSession.getId().equals(userSession.getId())) {
                return;
            }
            AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker) {
        String brokerId;
        if (userSession == null) {
            return;
        }
        UserModel user = userSession.getUser();
        userSession.setState(UserSessionModel.State.LOGGING_OUT);
        logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        AuthenticationManager.expireUserSessionCookie(session, userSession, realm, uriInfo, headers, connection);
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, userSession, uriInfo, headers);
        }
        if (logoutBroker && (brokerId = userSession.getNote("identity_provider")) != null) {
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId);
            try {
                identityProvider.backchannelLogout(session, userSession, uriInfo, realm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        session.sessions().removeUserSession(realm, userSession);
    }

    public static void backchannelLogoutClientSession(KeycloakSession session, RealmModel realm, ClientSessionModel clientSession, UserSessionModel userSession, UriInfo uriInfo, HttpHeaders headers) {
        ClientModel client = clientSession.getClient();
        if (client instanceof ClientModel && !client.isFrontchannelLogout() && !ClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) {
            String authMethod = clientSession.getAuthMethod();
            if (authMethod == null) {
                return;
            }
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            protocol.backchannelLogout(userSession, clientSession);
            clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
        }
    }

    public static void backchannelUserFromClient(KeycloakSession session, RealmModel realm, UserModel user, ClientModel client, UriInfo uriInfo, HttpHeaders headers) {
        String clientId = client.getId();
        List userSessions = session.sessions().getUserSessions(realm, user);
        for (UserSessionModel userSession : userSessions) {
            List clientSessions = userSession.getClientSessions();
            for (ClientSessionModel clientSession : clientSessions) {
                if (!clientSession.getClient().getId().equals(clientId)) continue;
                AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, userSession, uriInfo, headers);
                TokenManager.dettachClientSession(session.sessions(), realm, clientSession);
            }
        }
    }

    public static Response browserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        IdentityProvider identityProvider;
        Response response;
        if (userSession == null) {
            return null;
        }
        UserModel user = userSession.getUser();
        logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        LinkedList<ClientSessionModel> redirectClients = new LinkedList<ClientSessionModel>();
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            String authMethod;
            ClientModel client = clientSession.getClient();
            if (ClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) continue;
            if (client.isFrontchannelLogout()) {
                authMethod = clientSession.getAuthMethod();
                if (authMethod == null) continue;
                redirectClients.add(clientSession);
                continue;
            }
            authMethod = clientSession.getAuthMethod();
            if (authMethod == null) continue;
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            try {
                logger.debugv("backchannel logout to: {0}", (Object)client.getClientId());
                protocol.backchannelLogout(userSession, clientSession);
                clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.failedToLogoutClient(e);
            }
        }
        for (ClientSessionModel nextRedirectClient : redirectClients) {
            String authMethod = nextRedirectClient.getAuthMethod();
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            nextRedirectClient.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
            try {
                logger.debugv("frontchannel logout to: {0}", (Object)nextRedirectClient.getClient().getClientId());
                Response response2 = protocol.frontchannelLogout(userSession, nextRedirectClient);
                if (response2 == null) continue;
                logger.debug((Object)"returning frontchannel logout request to client");
                return response2;
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.failedToLogoutClient(e);
            }
        }
        String brokerId = userSession.getNote("identity_provider");
        if (brokerId != null && (response = (identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId)).keycloakInitiatedBrowserLogout(session, userSession, uriInfo, realm)) != null) {
            return response;
        }
        return AuthenticationManager.finishBrowserLogout(session, realm, userSession, uriInfo, connection, headers);
    }

    public static Response finishBrowserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
        AuthenticationManager.expireRememberMeCookie(realm, uriInfo, connection);
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        String method = userSession.getNote(KEYCLOAK_LOGOUT_PROTOCOL);
        EventBuilder event = new EventBuilder(realm, session, connection);
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, method);
        protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo).setEventBuilder(event);
        Response response = protocol.finishLogout(userSession);
        session.sessions().removeUserSession(realm, userSession);
        return response;
    }

    public static AccessToken createIdentityToken(RealmModel realm, UserModel user, UserSessionModel session, String issuer) {
        AccessToken token = new AccessToken();
        token.id(KeycloakModelUtils.generateId());
        token.issuedNow();
        token.subject(user.getId());
        token.issuer(issuer);
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (realm.getSsoSessionMaxLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getSsoSessionMaxLifespan());
        }
        return token;
    }

    public static void createLoginCookie(KeycloakSession keycloakSession, RealmModel realm, UserModel user, UserSessionModel session, UriInfo uriInfo, ClientConnection connection) {
        String cookiePath = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String issuer = Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName());
        AccessToken identityToken = AuthenticationManager.createIdentityToken(realm, user, session, issuer);
        String encoded = AuthenticationManager.encodeToken(keycloakSession, realm, identityToken);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        int maxAge = -1;
        if (session.isRememberMe()) {
            maxAge = realm.getSsoSessionMaxLifespan();
        }
        logger.debugv("Create login cookie - name: {0}, path: {1}, max-age: {2}", (Object)KEYCLOAK_IDENTITY_COOKIE, (Object)cookiePath, (Object)maxAge);
        CookieHelper.addCookie(KEYCLOAK_IDENTITY_COOKIE, encoded, cookiePath, null, null, maxAge, secureOnly, true);
        String sessionCookieValue = realm.getName() + "/" + user.getId();
        if (session != null) {
            sessionCookieValue = sessionCookieValue + "/" + session.getId();
        }
        CookieHelper.addCookie(KEYCLOAK_SESSION_COOKIE, sessionCookieValue, cookiePath, null, null, realm.getSsoSessionMaxLifespan(), secureOnly, false);
        P3PHelper.addP3PHeader(keycloakSession);
    }

    public static void createRememberMeCookie(RealmModel realm, String username, UriInfo uriInfo, ClientConnection connection) {
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KEYCLOAK_REMEMBER_ME, "username:" + username, path, null, null, 31536000, secureOnly, true);
    }

    public static String getRememberMeUsername(RealmModel realm, HttpHeaders headers) {
        String value;
        String[] s;
        Cookie cookie;
        if (realm.isRememberMe() && (cookie = (Cookie)headers.getCookies().get(KEYCLOAK_REMEMBER_ME)) != null && (s = (value = cookie.getValue()).split(":"))[0].equals(FORM_USERNAME) && s.length == 2) {
            return s[1];
        }
        return null;
    }

    protected static String encodeToken(KeycloakSession session, RealmModel realm, Object token) {
        KeyManager.ActiveKey activeKey = session.keys().getActiveKey(realm);
        logger.tracef("Encoding token with kid '%s'", (Object)activeKey.getKid());
        String encodedToken = new JWSBuilder().kid(activeKey.getKid()).jsonContent(token).rsa256(activeKey.getPrivateKey());
        return encodedToken;
    }

    public static void expireIdentityCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring identity cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_IDENTITY_COOKIE, path, true, connection);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_SESSION_COOKIE, path, false, connection);
    }

    public static void expireRememberMeCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring remember me cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String cookieName = KEYCLOAK_REMEMBER_ME;
        AuthenticationManager.expireCookie(realm, cookieName, path, true, connection);
    }

    protected static String getIdentityCookiePath(RealmModel realm, UriInfo uriInfo) {
        return AuthenticationManager.getRealmCookiePath(realm, uriInfo);
    }

    public static String getRealmCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()});
        return uri.getRawPath();
    }

    public static void expireCookie(RealmModel realm, String cookieName, String path, boolean httpOnly, ClientConnection connection) {
        logger.debugv("Expiring cookie: {0} path: {1}", (Object)cookieName, (Object)path);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(cookieName, "", path, null, "Expiring cookie", 0, secureOnly, httpOnly);
    }

    public AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        return AuthenticationManager.authenticateIdentityCookie(session, realm, true);
    }

    public static AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, boolean checkActive) {
        Cookie cookie = (Cookie)session.getContext().getRequestHeaders().getCookies().get(KEYCLOAK_IDENTITY_COOKIE);
        if (cookie == null || "".equals(cookie.getValue())) {
            logger.debugv("Could not find cookie: {0}", (Object)KEYCLOAK_IDENTITY_COOKIE);
            return null;
        }
        String tokenString = cookie.getValue();
        AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, session.getContext().getUri(), session.getContext().getConnection(), checkActive, false, tokenString, session.getContext().getRequestHeaders());
        if (authResult == null) {
            AuthenticationManager.expireIdentityCookie(realm, session.getContext().getUri(), session.getContext().getConnection());
            return null;
        }
        authResult.getSession().setLastSessionRefresh(Time.currentTime());
        return authResult;
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionModel clientSession, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event) {
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, clientSession.getAuthMethod());
        protocol.setRealm(realm).setHttpHeaders(request.getHttpHeaders()).setUriInfo(uriInfo).setEventBuilder(event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSession, request, uriInfo, clientConnection, event, protocol);
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionModel clientSession, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event, LoginProtocol protocol) {
        UserSessionModel oldSession;
        String oldSessionId;
        String[] split;
        Cookie sessionCookie = (Cookie)request.getHttpHeaders().getCookies().get(KEYCLOAK_SESSION_COOKIE);
        if (sessionCookie != null && (split = sessionCookie.getValue().split("/")).length >= 3 && !(oldSessionId = split[2]).equals(userSession.getId()) && (oldSession = session.sessions().getUserSession(realm, oldSessionId)) != null) {
            logger.debugv("Removing old user session: session: {0}", (Object)oldSessionId);
            session.sessions().removeUserSession(realm, oldSession);
        }
        session.getContext().resolveLocale(userSession.getUser());
        AuthenticationManager.createLoginCookie(session, realm, userSession.getUser(), userSession, uriInfo, clientConnection);
        if (userSession.getState() != UserSessionModel.State.LOGGED_IN) {
            userSession.setState(UserSessionModel.State.LOGGED_IN);
        }
        if (userSession.isRememberMe()) {
            AuthenticationManager.createRememberMeCookie(realm, userSession.getLoginUsername(), uriInfo, clientConnection);
        }
        if (!AuthenticationManager.isSSOAuthentication(clientSession)) {
            int authTime = Time.currentTime();
            userSession.setNote(AUTH_TIME, String.valueOf(authTime));
        }
        return protocol.authenticated(userSession, new ClientSessionCode(session, realm, clientSession));
    }

    public static boolean isSSOAuthentication(ClientSessionModel clientSession) {
        String ssoAuth = clientSession.getNote(SSO_AUTH);
        return Boolean.parseBoolean(ssoAuth);
    }

    public static Response nextActionAfterAuthentication(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        Response requiredAction = AuthenticationManager.actionRequired(session, userSession, clientSession, clientConnection, request, uriInfo, event);
        if (requiredAction != null) {
            return requiredAction;
        }
        return AuthenticationManager.finishedRequiredActions(session, userSession, clientSession, clientConnection, request, uriInfo, event);
    }

    public static Response finishedRequiredActions(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        if (clientSession.getNote(END_AFTER_REQUIRED_ACTIONS) != null) {
            Response response = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAttribute("skipLink", (Object)true).setSuccess("accountUpdatedMessage", new Object[0]).createInfoPage();
            session.sessions().removeUserSession(session.getContext().getRealm(), userSession);
            return response;
        }
        event.success();
        RealmModel realm = clientSession.getRealm();
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSession, request, uriInfo, clientConnection, event);
    }

    public static boolean isActionRequired(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        RealmModel realm = clientSession.getRealm();
        UserModel user = userSession.getUser();
        ClientModel client = clientSession.getClient();
        AuthenticationManager.evaluateRequiredActionTriggers(session, userSession, clientSession, clientConnection, request, uriInfo, event, realm, user);
        if (!user.getRequiredActions().isEmpty() || !clientSession.getRequiredActions().isEmpty()) {
            return true;
        }
        if (client.isConsentRequired()) {
            UserConsentModel grantedConsent = session.users().getConsentByClient(realm, user.getId(), client.getId());
            ClientSessionCode accessCode = new ClientSessionCode(session, realm, clientSession);
            for (RoleModel r : accessCode.getRequestedRoles()) {
                if (grantedConsent != null && grantedConsent.isRoleGranted(r)) continue;
                return true;
            }
            for (ProtocolMapperModel protocolMapper : accessCode.getRequestedProtocolMappers()) {
                if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null || grantedConsent != null && grantedConsent.isProtocolMapperGranted(protocolMapper)) continue;
                return true;
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return false;
    }

    public static Response actionRequired(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        RealmModel realm = clientSession.getRealm();
        UserModel user = userSession.getUser();
        ClientModel client = clientSession.getClient();
        AuthenticationManager.evaluateRequiredActionTriggers(session, userSession, clientSession, clientConnection, request, uriInfo, event, realm, user);
        logger.debugv("processAccessCode: go to oauth page?: {0}", (Object)client.isConsentRequired());
        event.detail("code_id", clientSession.getId());
        Set requiredActions = user.getRequiredActions();
        Response action = AuthenticationManager.executionActions(session, userSession, clientSession, request, event, realm, user, requiredActions);
        if (action != null) {
            return action;
        }
        requiredActions = clientSession.getRequiredActions();
        action = AuthenticationManager.executionActions(session, userSession, clientSession, request, event, realm, user, requiredActions);
        if (action != null) {
            return action;
        }
        if (client.isConsentRequired()) {
            UserConsentModel grantedConsent = session.users().getConsentByClient(realm, user.getId(), client.getId());
            LinkedList<Object> realmRoles = new LinkedList<Object>();
            MultivaluedMapImpl resourceRoles = new MultivaluedMapImpl();
            ClientSessionCode accessCode = new ClientSessionCode(session, realm, clientSession);
            for (Object r : accessCode.getRequestedRoles()) {
                if (grantedConsent != null && grantedConsent.isRoleGranted((RoleModel)r)) continue;
                if (r.getContainer() instanceof RealmModel) {
                    realmRoles.add(r);
                    continue;
                }
                resourceRoles.add((Object)((ClientModel)r.getContainer()).getClientId(), r);
            }
            LinkedList<ProtocolMapperModel> protocolMappers = new LinkedList<ProtocolMapperModel>();
            for (ProtocolMapperModel protocolMapper : accessCode.getRequestedProtocolMappers()) {
                if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null || grantedConsent != null && grantedConsent.isProtocolMapperGranted(protocolMapper)) continue;
                protocolMappers.add(protocolMapper);
            }
            if (realmRoles.size() > 0 || resourceRoles.size() > 0 || protocolMappers.size() > 0) {
                accessCode.setAction(ClientSessionModel.Action.REQUIRED_ACTIONS.name());
                clientSession.setNote(CURRENT_REQUIRED_ACTION, ClientSessionModel.Action.OAUTH_GRANT.name());
                return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setAccessRequest(realmRoles, (MultivaluedMap)resourceRoles, protocolMappers).createOAuthGrant(clientSession);
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return null;
    }

    protected static Response executionActions(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, Set<String> requiredActions) {
        for (String action : requiredActions) {
            RequiredActionProviderModel model = realm.getRequiredActionProviderByAlias(action);
            if (model == null) {
                logger.warnv("Could not find configuration for Required Action {0}, did you forget to register it?", (Object)action);
                continue;
            }
            if (!model.isEnabled()) continue;
            RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for Required Action: " + model.getProviderId() + " did you forget to declare it in a META-INF/services file?");
            }
            RequiredActionProvider actionProvider = (RequiredActionProvider)factory.create(session);
            RequiredActionContextResult context = new RequiredActionContextResult(userSession, clientSession, realm, event, session, request, user, factory);
            actionProvider.requiredActionChallenge((RequiredActionContext)context);
            if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
                LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getClientSession().getAuthMethod());
                protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(event);
                Response response = protocol.sendError(context.getClientSession(), LoginProtocol.Error.CONSENT_DENIED);
                event.error("rejected_by_user");
                return response;
            }
            if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
                clientSession.setNote(CURRENT_REQUIRED_ACTION, model.getProviderId());
                return context.getChallenge();
            }
            if (context.getStatus() != RequiredActionContext.Status.SUCCESS) continue;
            event.clone().event(EventType.CUSTOM_REQUIRED_ACTION).detail("custom_required_action", factory.getId()).success();
            clientSession.getUserSession().getUser().removeRequiredAction(factory.getId());
            clientSession.removeRequiredAction(factory.getId());
        }
        return null;
    }

    public static void evaluateRequiredActionTriggers(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event, RealmModel realm, UserModel user) {
        for (RequiredActionProviderModel model : realm.getRequiredActionProviders()) {
            if (!model.isEnabled()) continue;
            RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for Required Action: " + model.getProviderId() + " did you forget to declare it in a META-INF/services file?");
            }
            RequiredActionProvider provider = (RequiredActionProvider)factory.create(session);
            RequiredActionContextResult result = new RequiredActionContextResult(userSession, clientSession, realm, event, session, request, user, factory){

                @Override
                public void challenge(Response response) {
                    throw new RuntimeException("Not allowed to call challenge() within evaluateTriggers()");
                }

                @Override
                public void failure() {
                    throw new RuntimeException("Not allowed to call failure() within evaluateTriggers()");
                }

                @Override
                public void success() {
                    throw new RuntimeException("Not allowed to call success() within evaluateTriggers()");
                }

                @Override
                public void ignore() {
                    throw new RuntimeException("Not allowed to call ignore() within evaluateTriggers()");
                }
            };
            provider.evaluateTriggers((RequiredActionContext)result);
        }
    }

    protected static AuthResult verifyIdentityToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, boolean checkActive, boolean checkTokenType, String tokenString, HttpHeaders headers) {
        try {
            RSATokenVerifier verifier = RSATokenVerifier.create((String)tokenString).realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(checkActive).checkTokenType(checkTokenType);
            String kid = verifier.getHeader().getKeyId();
            PublicKey publicKey = session.keys().getPublicKey(realm, kid);
            if (publicKey == null) {
                logger.debugf("Identity cookie signed with unknown kid '%s'", (Object)kid);
                return null;
            }
            verifier.publicKey(publicKey);
            AccessToken token = verifier.verify().getToken();
            if (checkActive && (!token.isActive() || token.getIssuedAt() < realm.getNotBefore())) {
                logger.debug((Object)"Identity cookie expired");
                return null;
            }
            UserModel user = session.users().getUserById(token.getSubject(), realm);
            if (user == null || !user.isEnabled()) {
                logger.debug((Object)"Unknown user in identity token");
                return null;
            }
            UserSessionModel userSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (!AuthenticationManager.isSessionValid(realm, userSession)) {
                if (userSession != null) {
                    AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                }
                logger.debug((Object)"User session not active");
                return null;
            }
            return new AuthResult(user, userSession, token);
        }
        catch (VerificationException e) {
            logger.debugf("Failed to verify identity token: %s", (Object)e.getMessage());
            return null;
        }
    }

    public static class AuthResult {
        private final UserModel user;
        private final UserSessionModel session;
        private final AccessToken token;

        public AuthResult(UserModel user, UserSessionModel session, AccessToken token) {
            this.user = user;
            this.session = session;
            this.token = token;
        }

        public UserSessionModel getSession() {
            return this.session;
        }

        public UserModel getUser() {
            return this.user;
        }

        public AccessToken getToken() {
            return this.token;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        ACCOUNT_TEMPORARILY_DISABLED,
        ACCOUNT_DISABLED,
        ACTIONS_REQUIRED,
        INVALID_USER,
        INVALID_CREDENTIALS,
        MISSING_PASSWORD,
        MISSING_TOTP,
        FAILED;

    }
}

