/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.LinkedList;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;

public class MigrateTo2_3_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.3.0");

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            for (ClientModel client : realm.getClients()) {
                this.updateProtocolMappers((ProtocolMapperContainerModel)client);
            }
            for (ClientTemplateModel clientTemplate : realm.getClientTemplates()) {
                this.updateProtocolMappers((ProtocolMapperContainerModel)clientTemplate);
            }
        }
    }

    private void updateProtocolMappers(ProtocolMapperContainerModel client) {
        LinkedList<ProtocolMapperModel> toUpdate = new LinkedList<ProtocolMapperModel>();
        for (ProtocolMapperModel mapper : client.getProtocolMappers()) {
            if (mapper.getConfig().containsKey("userinfo.token.claim") || !mapper.getConfig().containsKey("id.token.claim")) continue;
            mapper.getConfig().put("userinfo.token.claim", mapper.getConfig().get("id.token.claim"));
            toUpdate.add(mapper);
        }
        for (ProtocolMapperModel mapper : toUpdate) {
            client.updateProtocolMapper(mapper);
        }
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

