/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

public class UserFullInvalidationEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String username;
    private String email;
    private String realmId;
    private boolean identityFederationEnabled;
    private Map<String, String> federatedIdentities;

    public static UserFullInvalidationEvent create(String userId, String username, String email, String realmId, boolean identityFederationEnabled, Collection<FederatedIdentityModel> federatedIdentities) {
        UserFullInvalidationEvent event = new UserFullInvalidationEvent();
        event.userId = userId;
        event.username = username;
        event.email = email;
        event.realmId = realmId;
        event.identityFederationEnabled = identityFederationEnabled;
        if (identityFederationEnabled) {
            event.federatedIdentities = new HashMap<String, String>();
            for (FederatedIdentityModel socialLink : federatedIdentities) {
                event.federatedIdentities.put(socialLink.getIdentityProvider(), socialLink.getUserId());
            }
        }
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public Map<String, String> getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public String toString() {
        return String.format("UserFullInvalidationEvent [ userId=%s, username=%s, email=%s ]", this.userId, this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.fullUserInvalidation(this.userId, this.username, this.email, this.realmId, this.identityFederationEnabled, this.federatedIdentities, invalidations);
    }
}

