/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAML11AssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.SAML11RequestParser;
import org.keycloak.saml.processing.core.parsers.saml.SAML11ResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLArtifactResolveParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLArtifactResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLAttributeQueryParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLAuthNRequestParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLSloRequestParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLSloResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntitiesDescriptorParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntityDescriptorParser;

public class SAMLParser
extends AbstractParser {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                QName startElementName = startElement.getName();
                String nsURI = startElementName.getNamespaceURI();
                String localPart = startElementName.getLocalPart();
                String elementName = StaxParserUtil.getStartElementName(startElement);
                if (elementName.equalsIgnoreCase(JBossSAMLConstants.ASSERTION.get()) || elementName.equals(JBossSAMLConstants.ENCRYPTED_ASSERTION.get())) {
                    if (nsURI.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        SAML11AssertionParser saml11AssertionParser = new SAML11AssertionParser();
                        return saml11AssertionParser.parse(xmlEventReader);
                    }
                    SAMLAssertionParser assertionParser = new SAMLAssertionParser();
                    return assertionParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.AUTHN_REQUEST.get().equals(startElementName.getLocalPart())) {
                    SAMLAuthNRequestParser authNRequestParser = new SAMLAuthNRequestParser();
                    return authNRequestParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.LOGOUT_REQUEST.get().equals(startElementName.getLocalPart())) {
                    SAMLSloRequestParser sloParser = new SAMLSloRequestParser();
                    return sloParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.LOGOUT_RESPONSE.get().equals(startElementName.getLocalPart())) {
                    SAMLSloResponseParser sloParser = new SAMLSloResponseParser();
                    return sloParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.RESPONSE.get().equals(startElementName.getLocalPart())) {
                    SAMLResponseParser responseParser = new SAMLResponseParser();
                    return responseParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.REQUEST_ABSTRACT.get().equals(startElementName.getLocalPart())) {
                    String xsiTypeValue = StaxParserUtil.getXSITypeValue(startElement);
                    throw new RuntimeException("PL0065: Parser : Unknown xsi:type=" + xsiTypeValue);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.ARTIFACT_RESOLVE.get().equals(startElementName.getLocalPart())) {
                    SAMLArtifactResolveParser artifactResolverParser = new SAMLArtifactResolveParser();
                    return artifactResolverParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.ARTIFACT_RESPONSE.get().equals(startElementName.getLocalPart())) {
                    SAMLArtifactResponseParser responseParser = new SAMLArtifactResponseParser();
                    return responseParser.parse(xmlEventReader);
                }
                if (JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(nsURI) && JBossSAMLConstants.ATTRIBUTE_QUERY.get().equals(startElementName.getLocalPart())) {
                    SAMLAttributeQueryParser responseParser = new SAMLAttributeQueryParser();
                    return responseParser.parse(xmlEventReader);
                }
                if (JBossSAMLConstants.ENTITY_DESCRIPTOR.get().equals(localPart)) {
                    SAMLEntityDescriptorParser entityDescriptorParser = new SAMLEntityDescriptorParser();
                    return entityDescriptorParser.parse(xmlEventReader);
                }
                if (JBossSAMLConstants.ENTITIES_DESCRIPTOR.get().equals(localPart)) {
                    SAMLEntitiesDescriptorParser entityDescriptorParser = new SAMLEntitiesDescriptorParser();
                    return entityDescriptorParser.parse(xmlEventReader);
                }
                if ("urn:oasis:names:tc:SAML:1.0:protocol".equals(nsURI) && JBossSAMLConstants.RESPONSE.get().equals(startElementName.getLocalPart())) {
                    SAML11ResponseParser responseParser = new SAML11ResponseParser();
                    return responseParser.parse(xmlEventReader);
                }
                if ("urn:oasis:names:tc:SAML:1.0:protocol".equals(nsURI) && "Request".equals(startElementName.getLocalPart())) {
                    SAML11RequestParser reqParser = new SAML11RequestParser();
                    return reqParser.parse(xmlEventReader);
                }
                throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw new RuntimeException("PL00067: Parsing has failed:SAML Parsing has failed");
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.ASSERTION_NSURI.get().equals(qname.getNamespaceURI());
    }
}

