/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.xml.DependencyFilter;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.ArtifactResolver;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.IoUtils;
import org.kie.scanner.KieModuleMetaData;

public class KieModuleMetaDataImpl
implements KieModuleMetaData {
    private final ArtifactResolver artifactResolver;
    private final Map<String, Collection<String>> classes = new HashMap<String, Collection<String>>();
    private final Map<String, String> processes = new HashMap<String, String>();
    private final Map<URI, File> jars = new HashMap<URI, File>();
    private final Map<String, TypeMetaInfo> typeMetaInfos = new HashMap<String, TypeMetaInfo>();
    private final Map<String, Set<String>> rulesByPackage = new HashMap<String, Set<String>>();
    private final Set<String> packages = new HashSet<String>();
    private final DependencyFilter dependencyFilter;
    private ProjectClassLoader classLoader;
    private ReleaseId releaseId;
    private InternalKieModule kieModule;

    public KieModuleMetaDataImpl(ReleaseId releaseId, DependencyFilter dependencyFilter) {
        this.artifactResolver = ArtifactResolver.getResolverFor(releaseId, false);
        this.releaseId = releaseId;
        this.dependencyFilter = dependencyFilter;
        this.init();
    }

    public KieModuleMetaDataImpl(File pomFile, DependencyFilter dependencyFilter) {
        this.artifactResolver = ArtifactResolver.getResolverFor(pomFile);
        this.dependencyFilter = dependencyFilter;
        this.init();
    }

    public KieModuleMetaDataImpl(InternalKieModule kieModule, DependencyFilter dependencyFilter) {
        this.kieModule = kieModule;
        this.artifactResolver = ArtifactResolver.getResolverFor(kieModule.getPomModel());
        this.dependencyFilter = dependencyFilter;
        for (String file : kieModule.getFileNames()) {
            if (this.indexClass(file) || !file.endsWith("META-INF/kmodule.info")) continue;
            this.indexMetaInfo(kieModule.getBytes(file));
        }
        this.init();
    }

    @Override
    public Collection<String> getPackages() {
        return this.packages;
    }

    @Override
    public Collection<String> getClasses(String packageName) {
        Collection<String> classesInPkg = this.classes.get(packageName);
        return classesInPkg != null ? classesInPkg : Collections.emptyList();
    }

    @Override
    public Class<?> getClass(String pkgName, String className) {
        try {
            return Class.forName(pkgName == null || pkgName.trim().length() == 0 ? className : pkgName + "." + className, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public TypeMetaInfo getTypeMetaInfo(Class<?> clazz) {
        TypeMetaInfo typeMetaInfo = this.typeMetaInfos.get(clazz.getName());
        return typeMetaInfo != null ? typeMetaInfo : new TypeMetaInfo(clazz);
    }

    @Override
    public Collection<String> getRuleNamesInPackage(String packageName) {
        Set<String> rulesPerPackage = this.rulesByPackage.get(packageName);
        return rulesPerPackage != null ? rulesPerPackage : Collections.emptyList();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = new URL[this.jars.size()];
            int i = 0;
            for (File jar : this.jars.values()) {
                try {
                    urls[i++] = jar.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)new URLClassLoader(urls, this.getClass().getClassLoader()));
            if (this.kieModule != null) {
                Map classes = this.kieModule.getClassesMap(true);
                for (Map.Entry entry : classes.entrySet()) {
                    this.classLoader.storeClass(ClassUtils.convertResourceToClassName((String)((String)entry.getKey())), (String)entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        return this.classLoader;
    }

    private void init() {
        if (this.releaseId != null) {
            this.addArtifact(this.artifactResolver.resolveArtifact(this.releaseId));
        }
        if (this.kieModule != null) {
            for (ReleaseId releaseId : this.kieModule.getPomModel().getDependencies(this.dependencyFilter)) {
                this.addArtifact(this.artifactResolver.resolveArtifact(releaseId));
            }
        } else {
            for (DependencyDescriptor dep : this.artifactResolver.getAllDependecies(this.dependencyFilter)) {
                this.addArtifact(this.artifactResolver.resolveArtifact(dep.getReleaseId()));
            }
        }
        this.packages.addAll(this.classes.keySet());
        this.packages.addAll(this.rulesByPackage.keySet());
    }

    private void addArtifact(Artifact artifact) {
        if (artifact != null && artifact.getExtension() != null && artifact.getExtension().equals("jar")) {
            this.addJar(artifact.getFile());
        }
    }

    private void addJar(File jarFile) {
        URI uri = jarFile.toURI();
        if (!this.jars.containsKey(uri)) {
            this.jars.put(uri, jarFile);
            this.scanJar(jarFile);
        }
    }

    private void scanJar(File jarFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String pathName = entry.getName();
                if (pathName.endsWith("bpmn2")) {
                    this.processes.put(pathName, new String(org.drools.core.util.IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry), IoUtils.UTF8_CHARSET));
                }
                if (this.indexClass(pathName) || !pathName.endsWith("META-INF/kmodule.info")) continue;
                this.indexMetaInfo(org.drools.core.util.IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean indexClass(String pathName) {
        if (!pathName.endsWith(".class")) {
            return false;
        }
        int separator = pathName.lastIndexOf(47);
        String packageName = separator > 0 ? pathName.substring(0, separator).replace('/', '.') : "";
        String className = pathName.substring(separator + 1, pathName.length() - ".class".length());
        Collection<String> pkg = this.classes.get(packageName);
        if (pkg == null) {
            pkg = new HashSet<String>();
            this.classes.put(packageName, pkg);
        }
        pkg.add(className);
        return true;
    }

    private void indexMetaInfo(byte[] bytes) {
        KieModuleMetaInfo info = KieModuleMetaInfo.unmarshallMetaInfos((String)new String(bytes, IoUtils.UTF8_CHARSET));
        this.typeMetaInfos.putAll(info.getTypeMetaInfos());
        this.rulesByPackage.putAll(info.getRulesByPackage());
    }

    @Override
    public Map<String, String> getProcesses() {
        return this.processes;
    }
}

