/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPConfigDecorator;

public class LDAPIdentityStoreRegistry {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStoreRegistry.class);
    private Map<String, LDAPIdentityStoreContext> ldapStores = new ConcurrentHashMap<String, LDAPIdentityStoreContext>();

    public LDAPIdentityStore getLdapStore(ComponentModel ldapModel, Map<ComponentModel, LDAPConfigDecorator> configDecorators) {
        LDAPIdentityStoreContext context = this.ldapStores.get(ldapModel.getId());
        MultivaluedHashMap configModel = ldapModel.getConfig();
        LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)configModel);
        for (Map.Entry<ComponentModel, LDAPConfigDecorator> entry : configDecorators.entrySet()) {
            ComponentModel mapperModel = entry.getKey();
            LDAPConfigDecorator decorator = entry.getValue();
            decorator.updateLDAPConfig(ldapConfig, mapperModel);
        }
        if (context == null || !ldapConfig.equals(context.config)) {
            this.logLDAPConfig(ldapModel.getName(), ldapConfig);
            LDAPIdentityStore store = LDAPIdentityStoreRegistry.createLdapIdentityStore(ldapConfig);
            context = new LDAPIdentityStoreContext(ldapConfig, store);
            this.ldapStores.put(ldapModel.getId(), context);
        }
        return context.store;
    }

    private void logLDAPConfig(String fedProviderDisplayName, LDAPConfig ldapConfig) {
        logger.infof("Creating new LDAP Store for the LDAP storage provider: '%s', LDAP Configuration: %s", (Object)fedProviderDisplayName, (Object)ldapConfig.toString());
    }

    public static LDAPIdentityStore createLdapIdentityStore(LDAPConfig cfg) {
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "1000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        return new LDAPIdentityStore(cfg);
    }

    private static void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private class LDAPIdentityStoreContext {
        private LDAPConfig config;
        private LDAPIdentityStore store;

        private LDAPIdentityStoreContext(LDAPConfig config, LDAPIdentityStore store) {
            this.config = config;
            this.store = store;
        }
    }
}

