/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.group;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;

public class GroupLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "group-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties;
    protected static final Map<String, UserRolesRetrieveStrategy> userGroupsStrategies;
    protected static final List<String> MEMBERSHIP_TYPES;
    protected static final List<String> MODES;
    protected static final List<String> ROLE_RETRIEVERS;

    private static List<ProviderConfigProperty> getProps(ComponentModel parent) {
        String roleObjectClasses = "groupOfNames";
        String mode = LDAPGroupMapperMode.LDAP_ONLY.toString();
        String membershipUserAttribute = "uid";
        if (parent != null) {
            LDAPConfig config = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            roleObjectClasses = config.isActiveDirectory() ? "group" : "groupOfNames";
            mode = config.getEditMode() == UserStorageProvider.EditMode.WRITABLE ? LDAPGroupMapperMode.LDAP_ONLY.toString() : LDAPGroupMapperMode.READ_ONLY.toString();
            membershipUserAttribute = config.getUsernameLdapAttribute();
        }
        return ProviderConfigurationBuilder.create().property().name("groups.dn").label("LDAP Groups DN").helpText("LDAP DN where are groups of this tree saved. For example 'ou=groups,dc=example,dc=org' ").type("String").add().property().name("group.name.ldap.attribute").label("Group Name LDAP Attribute").helpText("Name of LDAP attribute, which is used in group objects for name and RDN of group. Usually it will be 'cn' . In this case typical group/role object may have DN like 'cn=Group1,ou=groups,dc=example,dc=org' ").type("String").defaultValue((Object)"cn").add().property().name("group.object.classes").label("Group Object Classes").helpText("Object class (or classes) of the group object. It's divided by comma if more classes needed. In typical LDAP deployment it could be 'groupOfNames' . In Active Directory it's usually 'group' ").type("String").defaultValue((Object)roleObjectClasses).add().property().name("preserve.group.inheritance").label("Preserve Group Inheritance").helpText("Flag whether group inheritance from LDAP should be propagated to Keycloak. If false, then all LDAP groups will be mapped as flat top-level groups in Keycloak. Otherwise group inheritance is preserved into Keycloak, but the group sync might fail if LDAP structure contains recursions or multiple parent groups per child groups").type("boolean").defaultValue((Object)"true").add().property().name("membership.ldap.attribute").label("Membership LDAP Attribute").helpText("Name of LDAP attribute on group, which is used for membership mappings. Usually it will be 'member' .However when 'Membership Attribute Type' is 'UID' then 'Membership LDAP Attribute' could be typically 'memberUid' .").type("String").defaultValue((Object)"member").add().property().name("membership.attribute.type").label("Membership Attribute Type").helpText("DN means that LDAP group has it's members declared in form of their full DN. For example 'member: uid=john,ou=users,dc=example,dc=com' . UID means that LDAP group has it's members declared in form of pure user uids. For example 'memberUid: john' .").type("List").options(MEMBERSHIP_TYPES).defaultValue((Object)MembershipType.DN.toString()).add().property().name("membership.user.ldap.attribute").label("Membership User LDAP Attribute").helpText("Used just if Membership Attribute Type is UID. It is name of LDAP attribute on user, which is used for membership mappings. Usually it will be 'uid' . For example if value of 'Membership User LDAP Attribute' is 'uid' and  LDAP group has  'memberUid: john', then it is expected that particular LDAP user will have attribute 'uid: john' .").type("String").defaultValue((Object)membershipUserAttribute).add().property().name("groups.ldap.filter").label("LDAP Filter").helpText("LDAP Filter adds additional custom filter to the whole query for retrieve LDAP groups. Leave this empty if no additional filtering is needed and you want to retrieve all groups from LDAP. Otherwise make sure that filter starts with '(' and ends with ')'").type("String").add().property().name("mode").label("Mode").helpText("LDAP_ONLY means that all group mappings of users are retrieved from LDAP and saved into LDAP. READ_ONLY is Read-only LDAP mode where group mappings are retrieved from both LDAP and DB and merged together. New group joins are not saved to LDAP but to DB. IMPORT is Read-only LDAP mode where group mappings are retrieved from LDAP just at the time when user is imported from LDAP and then they are saved to local keycloak DB.").type("List").options(MODES).defaultValue((Object)mode).add().property().name("user.roles.retrieve.strategy").label("User Groups Retrieve Strategy").helpText("Specify how to retrieve groups of user. LOAD_GROUPS_BY_MEMBER_ATTRIBUTE means that roles of user will be retrieved by sending LDAP query to retrieve all groups where 'member' is our user. GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE means that groups of user will be retrieved from 'memberOf' attribute of our user. LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY is applicable just in Active Directory and it means that groups of user will be retrieved recursively with usage of LDAP_MATCHING_RULE_IN_CHAIN Ldap extension.").type("List").options(ROLE_RETRIEVERS).defaultValue((Object)"LOAD_GROUPS_BY_MEMBER_ATTRIBUTE").add().property().name("mapped.group.attributes").label("Mapped Group Attributes").helpText("List of names of attributes divided by comma. This points to the list of attributes on LDAP group, which will be mapped as attributes of Group in Keycloak. Leave this empty if no additional group attributes are required to be mapped in Keycloak. ").type("String").add().property().name("drop.non.existing.groups.during.sync").label("Drop non-existing groups during sync").helpText("If this flag is true, then during sync of groups from LDAP to Keycloak, we will keep just those Keycloak groups, which still exists in LDAP. Rest will be deleted").type("boolean").defaultValue((Object)"false").add().build();
    }

    @Override
    public String getHelpText() {
        return "Used to map group mappings of groups from some LDAP DN to Keycloak group mappings";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, Object> getTypeMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("fedToKeycloakSyncSupported", true);
        metadata.put("fedToKeycloakSyncMessage", "sync-ldap-groups-to-keycloak");
        metadata.put("keycloakToFedSyncSupported", true);
        metadata.put("keycloakToFedSyncMessage", "sync-keycloak-groups-to-ldap");
        return metadata;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        this.checkMandatoryConfigAttribute("groups.dn", "LDAP Groups DN", config);
        this.checkMandatoryConfigAttribute("mode", "Mode", config);
        String mt = (String)config.getConfig().getFirst((Object)"membership.attribute.type");
        MembershipType membershipType = mt == null ? MembershipType.DN : Enum.valueOf(MembershipType.class, mt);
        boolean preserveGroupInheritance = Boolean.parseBoolean((String)config.getConfig().getFirst((Object)"preserve.group.inheritance"));
        if (preserveGroupInheritance && membershipType != MembershipType.DN) {
            throw new ComponentValidationException("ldapErrorCantPreserveGroupInheritanceWithUIDMembershipType", new Object[0]);
        }
        LDAPUtils.validateCustomLdapFilter((String)config.getConfig().getFirst((Object)"groups.ldap.filter"));
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new GroupLDAPStorageMapper(mapperModel, federationProvider, this);
    }

    protected UserRolesRetrieveStrategy getUserGroupsRetrieveStrategy(String strategyKey) {
        return userGroupsStrategies.get(strategyKey);
    }

    static {
        userGroupsStrategies = new LinkedHashMap<String, UserRolesRetrieveStrategy>();
        MEMBERSHIP_TYPES = new LinkedList<String>();
        MODES = new LinkedList<String>();
        userGroupsStrategies.put("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", new UserRolesRetrieveStrategy.LoadRolesByMember());
        userGroupsStrategies.put("GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE", new UserRolesRetrieveStrategy.GetRolesFromUserMemberOfAttribute());
        userGroupsStrategies.put("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY", new UserRolesRetrieveStrategy.LoadRolesByMemberRecursively());
        for (MembershipType membershipType : MembershipType.values()) {
            MEMBERSHIP_TYPES.add(membershipType.toString());
        }
        for (Enum enum_ : LDAPGroupMapperMode.values()) {
            MODES.add(enum_.toString());
        }
        ROLE_RETRIEVERS = new LinkedList<String>(userGroupsStrategies.keySet());
        List<ProviderConfigProperty> config = GroupLDAPStorageMapperFactory.getProps(null);
        configProperties = config;
    }
}

