/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.saml.v2.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.RequestedAttributeType;

public class AttributeConsumingServiceType {
    protected List<LocalizedNameType> serviceName = new ArrayList<LocalizedNameType>();
    protected List<LocalizedNameType> serviceDescription = new ArrayList<LocalizedNameType>();
    protected List<RequestedAttributeType> requestedAttribute = new ArrayList<RequestedAttributeType>();
    protected int index;
    protected Boolean isDefault = Boolean.FALSE;

    public AttributeConsumingServiceType(int index) {
        this.index = index;
    }

    public void addServiceName(LocalizedNameType service) {
        this.serviceName.add(service);
    }

    public void addServiceDescription(LocalizedNameType desc) {
        this.serviceDescription.add(desc);
    }

    public void addRequestedAttribute(RequestedAttributeType req) {
        this.requestedAttribute.add(req);
    }

    public void removeServiceName(LocalizedNameType service) {
        this.serviceName.remove(service);
    }

    public void removeServiceDescription(LocalizedNameType desc) {
        this.serviceDescription.remove(desc);
    }

    public void removeRequestedAttribute(RequestedAttributeType req) {
        this.requestedAttribute.remove(req);
    }

    public List<LocalizedNameType> getServiceName() {
        return Collections.unmodifiableList(this.serviceName);
    }

    public List<LocalizedNameType> getServiceDescription() {
        return Collections.unmodifiableList(this.serviceDescription);
    }

    public List<RequestedAttributeType> getRequestedAttribute() {
        return Collections.unmodifiableList(this.requestedAttribute);
    }

    public int getIndex() {
        return this.index;
    }

    public Boolean isIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean value) {
        this.isDefault = value;
    }
}

