/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.RealmAuth;

public class ResourceSetService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private ResourceServer resourceServer;

    public ResourceSetService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ResourceRepresentation resource) {
        String ownerId;
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource existingResource = storeFactory.getResourceStore().findByName(resource.getName(), this.resourceServer.getId());
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (existingResource != null && existingResource.getResourceServer().getId().equals(this.resourceServer.getId()) && existingResource.getOwner().equals(owner)) {
            return ErrorResponse.exists("Resource with name [" + resource.getName() + "] already exists.");
        }
        if (owner != null && (ownerId = owner.getId()) != null && !this.resourceServer.getClientId().equals(ownerId)) {
            RealmModel realm = this.authorization.getRealm();
            KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
            UserProvider users = keycloakSession.users();
            UserModel ownerModel = users.getUserById(ownerId, realm);
            if (ownerModel == null) {
                ownerModel = users.getUserByUsername(ownerId, realm);
            }
            if (ownerModel == null) {
                return ErrorResponse.error("Owner must be a valid username or user identifier. If the resource server, the client id or null.", Response.Status.BAD_REQUEST);
            }
            owner.setId(ownerModel.getId());
        }
        Resource model = RepresentationToModel.toModel((ResourceRepresentation)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        ResourceRepresentation representation = new ResourceRepresentation();
        representation.setId(model.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ResourceRepresentation resource) {
        this.requireManage();
        resource.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        Resource model = resourceStore.findById(resource.getId(), this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RepresentationToModel.toModel((ResourceRepresentation)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource resource = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByResource(id, this.resourceServer.getId());
        for (Policy policyModel : policies) {
            if (policyModel.getResources().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.removeResource(resource);
        }
        storeFactory.getResourceStore().delete(id);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Resource)model, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization, (Boolean)true)).build();
    }

    @Path(value="{id}/scopes")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getScopes(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List scopes = model.getScopes().stream().map(scope -> {
            ScopeRepresentation representation = new ScopeRepresentation();
            representation.setId(scope.getId());
            representation.setName(scope.getName());
            return representation;
        }).collect(Collectors.toList());
        if (model.getType() != null) {
            ResourceStore resourceStore = this.authorization.getStoreFactory().getResourceStore();
            for (Resource typed : resourceStore.findByType(model.getType(), this.resourceServer.getId())) {
                if (!typed.getOwner().equals(this.resourceServer.getClientId()) || typed.getId().equals(model.getId())) continue;
                scopes.addAll(typed.getScopes().stream().map(model1 -> {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setId(model1.getId());
                    scope.setName(model1.getName());
                    String iconUri = model1.getIconUri();
                    if (iconUri != null) {
                        scope.setIconUri(iconUri);
                    }
                    return scope;
                }).filter(scopeRepresentation -> !scopes.contains(scopeRepresentation)).collect(Collectors.toList()));
            }
        }
        return Response.ok(scopes).build();
    }

    @Path(value="{id}/permissions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getPermissions(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        HashSet policies = new HashSet();
        policies.addAll(policyStore.findByResource(model.getId(), this.resourceServer.getId()));
        policies.addAll(policyStore.findByResourceType(model.getType(), this.resourceServer.getId()));
        policies.addAll(policyStore.findByScopeIds(model.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toList()), this.resourceServer.getId()));
        ArrayList<PolicyRepresentation> representation = new ArrayList<PolicyRepresentation>();
        for (Policy policyModel : policies) {
            PolicyRepresentation policy = new PolicyRepresentation();
            policy.setId(policyModel.getId());
            policy.setName(policyModel.getName());
            policy.setType(policyModel.getType());
            if (representation.contains(policy)) continue;
            representation.add(policy);
        }
        return Response.ok(representation).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response find(@QueryParam(value="name") String name) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Resource model = storeFactory.getResourceStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Resource)model, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization)).build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="_id") String id, @QueryParam(value="name") String name, @QueryParam(value="uri") String uri, @QueryParam(value="owner") String owner, @QueryParam(value="type") String type, @QueryParam(value="scope") String scope, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (deep == null) {
            deep = true;
        }
        HashMap<String, String[]> search = new HashMap<String, String[]>();
        if (id != null && !"".equals(id.trim())) {
            search.put("id", new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put("name", new String[]{name});
        }
        if (uri != null && !"".equals(uri.trim())) {
            search.put("uri", new String[]{uri});
        }
        if (owner != null && !"".equals(owner.trim())) {
            RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
            ClientModel clientModel = realm.getClientByClientId(owner);
            if (clientModel != null) {
                owner = clientModel.getId();
            } else {
                UserModel user = this.authorization.getKeycloakSession().users().getUserByUsername(owner, realm);
                if (user != null) {
                    owner = user.getId();
                }
            }
            search.put("owner", new String[]{owner});
        }
        if (type != null && !"".equals(type.trim())) {
            search.put("type", new String[]{type});
        }
        if (scope != null && !"".equals(scope.trim())) {
            HashMap<String, String[]> scopeFilter = new HashMap<String, String[]>();
            scopeFilter.put("name", new String[]{scope});
            List scopes = this.authorization.getStoreFactory().getScopeStore().findByResourceServer(scopeFilter, this.resourceServer.getId(), -1, -1);
            if (scopes.isEmpty()) {
                return Response.ok(Collections.emptyList()).build();
            }
            search.put("scope", (String[])scopes.stream().map(Scope::getId).toArray(String[]::new));
        }
        Boolean finalDeep = deep;
        return Response.ok(storeFactory.getResourceStore().findByResourceServer(search, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(resource -> ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization, (Boolean)finalDeep)).collect(Collectors.toList())).build();
    }

    private void requireView() {
        if (this.auth != null) {
            this.auth.requireView();
        }
    }

    private void requireManage() {
        if (this.auth != null) {
            this.auth.requireManage();
        }
    }
}

