/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.validation.Validation;

public class VerifyEmail
implements RequiredActionProvider,
RequiredActionFactory {
    private static final Logger logger = Logger.getLogger(VerifyEmail.class);

    public void evaluateTriggers(RequiredActionContext context) {
        if (context.getRealm().isVerifyEmail() && !context.getUser().isEmailVerified()) {
            context.getUser().addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            logger.debug((Object)"User is required to verify email");
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        if (context.getUser().isEmailVerified()) {
            context.success();
            return;
        }
        if (Validation.isBlank(context.getUser().getEmail())) {
            context.ignore();
            return;
        }
        context.getEvent().clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", context.getUser().getEmail()).success();
        LoginActionsService.createActionCookie(context.getRealm(), context.getUriInfo(), context.getConnection(), context.getUserSession().getId());
        VerifyEmail.setupKey(context.getClientSession());
        LoginFormsProvider loginFormsProvider = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setClientSessionCode(context.generateCode()).setClientSession(context.getClientSession()).setUser(context.getUser());
        Response challenge = loginFormsProvider.createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        context.failure();
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Verify Email";
    }

    public String getId() {
        return UserModel.RequiredAction.VERIFY_EMAIL.name();
    }

    public static void setupKey(ClientSessionModel clientSession) {
        String secret = HmacOTP.generateSecret((int)10);
        clientSession.setNote("VERIFY_EMAIL_KEY", secret);
    }
}

