/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.resource;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.resource.RegistrationResponse;
import org.keycloak.authorization.protection.resource.representation.UmaResourceRepresentation;
import org.keycloak.authorization.protection.resource.representation.UmaScopeRepresentation;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponseException;

public class ResourceService {
    private final ResourceServer resourceServer;
    private final ResourceSetService resourceManager;
    private final Identity identity;
    private final AuthorizationProvider authorization;

    public ResourceService(ResourceServer resourceServer, Identity identity, ResourceSetService resourceManager, AuthorizationProvider authorization) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.resourceManager = resourceManager;
        this.authorization = authorization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(UmaResourceRepresentation umaResource) {
        this.checkResourceServerSettings();
        ResourceRepresentation resource = this.toResourceRepresentation(umaResource);
        Response response = this.resourceManager.create(resource);
        if (response.getEntity() instanceof ResourceRepresentation) {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.toUmaRepresentation((ResourceRepresentation)response.getEntity())).build();
        }
        return response;
    }

    @Path(value="/{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.checkResourceServerSettings();
        return this.resourceManager.delete(id);
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public RegistrationResponse findById(@PathParam(value="id") String id) {
        Response response = this.resourceManager.findById(id);
        UmaResourceRepresentation resource = this.toUmaRepresentation((ResourceRepresentation)response.getEntity());
        if (resource == null) {
            throw new ErrorResponseException("not_found", "Resource with id [" + id + "] not found.", Response.Status.NOT_FOUND);
        }
        return new RegistrationResponse(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Set<String> find(@QueryParam(value="filter") String filter) {
        if (filter == null) {
            return this.findAll();
        }
        return this.findByFilter(filter);
    }

    private Set<String> findAll() {
        Response response = this.resourceManager.find(null, null, null, null, null, null, true, -1, -1);
        List resources = (List)response.getEntity();
        return resources.stream().map(ResourceRepresentation::getId).collect(Collectors.toSet());
    }

    private Set<String> findByFilter(String filter) {
        Set<Object> resources = new HashSet();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (filter != null) {
            for (String currentFilter : filter.split("&")) {
                String[] parts = currentFilter.split("=");
                String filterType = parts[0];
                String filterValue = parts.length > 1 ? parts[1] : null;
                if ("name".equals(filterType)) {
                    resources.add(ModelToRepresentation.toRepresentation((Resource)storeFactory.getResourceStore().findByName(filterValue, this.resourceServer.getId()), (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization));
                    continue;
                }
                if ("type".equals(filterType)) {
                    resources.addAll(storeFactory.getResourceStore().findByResourceServer(this.resourceServer.getId()).stream().filter(description -> filterValue == null || filterValue.equals(description.getType())).collect(Collectors.toSet()).stream().map(resource -> ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization)).collect(Collectors.toList()));
                    continue;
                }
                if ("uri".equals(filterType)) {
                    resources.addAll(storeFactory.getResourceStore().findByUri(filterValue, this.resourceServer.getId()).stream().map(resource -> ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization)).collect(Collectors.toList()));
                    continue;
                }
                if (!"owner".equals(filterType)) continue;
                resources.addAll(storeFactory.getResourceStore().findByOwner(filterValue, this.resourceServer.getId()).stream().map(resource -> ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization)).collect(Collectors.toList()));
            }
        } else {
            resources = storeFactory.getResourceStore().findByOwner(this.identity.getId(), this.resourceServer.getId()).stream().map(resource -> ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization)).collect(Collectors.toSet());
        }
        return resources.stream().map(ResourceRepresentation::getId).collect(Collectors.toSet());
    }

    private ResourceRepresentation toResourceRepresentation(UmaResourceRepresentation umaResource) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(umaResource.getId());
        resource.setIconUri(umaResource.getIconUri());
        resource.setName(umaResource.getName());
        resource.setUri(umaResource.getUri());
        resource.setType(umaResource.getType());
        ResourceOwnerRepresentation owner = new ResourceOwnerRepresentation();
        String ownerId = umaResource.getOwner();
        if (ownerId == null) {
            ownerId = this.identity.getId();
        }
        owner.setId(ownerId);
        resource.setOwner(owner);
        resource.setScopes(umaResource.getScopes().stream().map(representation -> {
            ScopeRepresentation scopeRepresentation = new ScopeRepresentation();
            scopeRepresentation.setId(representation.getId());
            scopeRepresentation.setName(representation.getName());
            scopeRepresentation.setIconUri(representation.getIconUri());
            return scopeRepresentation;
        }).collect(Collectors.toSet()));
        return resource;
    }

    private UmaResourceRepresentation toUmaRepresentation(ResourceRepresentation representation) {
        if (representation == null) {
            return null;
        }
        UmaResourceRepresentation resource = new UmaResourceRepresentation();
        resource.setId(representation.getId());
        resource.setIconUri(representation.getIconUri());
        resource.setName(representation.getName());
        resource.setUri(representation.getUri());
        resource.setType(representation.getType());
        if (representation.getOwner() != null) {
            resource.setOwner(representation.getOwner().getId());
        }
        resource.setScopes(representation.getScopes().stream().map(scopeRepresentation -> {
            UmaScopeRepresentation umaScopeRep = new UmaScopeRepresentation();
            umaScopeRep.setId(scopeRepresentation.getId());
            umaScopeRep.setName(scopeRepresentation.getName());
            umaScopeRep.setIconUri(scopeRepresentation.getIconUri());
            return umaScopeRep;
        }).collect(Collectors.toSet()));
        return resource;
    }

    private void checkResourceServerSettings() {
        if (!this.resourceServer.isAllowRemoteResourceManagement()) {
            throw new ErrorResponseException("not_supported", "Remote management is disabled.", Response.Status.BAD_REQUEST);
        }
    }
}

