/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.P3PHelper;

public class LoginStatusIframeEndpoint {
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    private RealmModel realm;

    public LoginStatusIframeEndpoint(RealmModel realm) {
        this.realm = realm;
    }

    @GET
    @Produces(value={"text/html"})
    public Response getLoginStatusIframe() {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe.html");
        if (resource != null) {
            P3PHelper.addP3PHeader(this.session);
            return Response.ok((Object)resource).type(MediaType.TEXT_HTML_TYPE).cacheControl(CacheControlUtil.getDefaultCacheControl()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="init")
    public Response preCheck(@QueryParam(value="client_id") String clientId, @QueryParam(value="origin") String origin) {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel client = this.session.realms().getClientByClientId(clientId, realm);
            if (client != null) {
                Set<String> validWebOrigins = WebOriginsUtils.resolveValidWebOrigins(this.uriInfo, client);
                validWebOrigins.add(UriUtils.getOrigin((URI)this.uriInfo.getRequestUri()));
                if (validWebOrigins.contains("*") || validWebOrigins.contains(origin)) {
                    return Response.noContent().build();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

