/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.jpa.entity.BrokerLinkEntity;
import org.keycloak.storage.jpa.entity.FederatedUser;
import org.keycloak.storage.jpa.entity.FederatedUserAttributeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentProtocolMapperEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentRoleEntity;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialAttributeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialEntity;
import org.keycloak.storage.jpa.entity.FederatedUserGroupMembershipEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRequiredActionEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRoleMappingEntity;

public class JpaUserFederatedStorageProvider
implements UserFederatedStorageProvider,
UserCredentialStore {
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserFederatedStorageProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void close() {
    }

    protected void createIndex(RealmModel realm, String userId) {
        if (this.em.find(FederatedUser.class, (Object)userId) == null) {
            FederatedUser fedUser = new FederatedUser();
            fedUser.setId(userId);
            fedUser.setRealmId(realm.getId());
            fedUser.setStorageProviderId(new StorageId(userId).getProviderId());
            this.em.persist((Object)fedUser);
        }
    }

    public void setAttribute(RealmModel realm, String userId, String name, List<String> values) {
        this.createIndex(realm, userId);
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
        for (String value : values) {
            this.persistAttributeValue(realm, userId, name, value);
        }
    }

    private void deleteAttribute(RealmModel realm, String userId, String name) {
        this.em.createNamedQuery("deleteUserFederatedAttributesByUserAndName").setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).executeUpdate();
    }

    private void persistAttributeValue(RealmModel realm, String userId, String name, String value) {
        FederatedUserAttributeEntity attr = new FederatedUserAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setUserId(userId);
        attr.setRealmId(realm.getId());
        attr.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)attr);
    }

    public void setSingleAttribute(RealmModel realm, String userId, String name, String value) {
        this.createIndex(realm, userId);
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
        this.persistAttributeValue(realm, userId, name, value);
    }

    public void removeAttribute(RealmModel realm, String userId, String name) {
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
    }

    public MultivaluedHashMap<String, String> getAttributes(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByUser", FederatedUserAttributeEntity.class);
        List list = query.setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).getResultList();
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (FederatedUserAttributeEntity entity : list) {
            result.add((Object)entity.getName(), (Object)entity.getValue());
        }
        return result;
    }

    public List<String> getUsersByUserAttribute(RealmModel realm, String name, String value) {
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByNameAndValue", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).setParameter("value", (Object)value);
        return query.getResultList();
    }

    public String getUserByFederatedIdentity(FederatedIdentityModel link, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByBrokerLinkAndRealm", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)link.getIdentityProvider()).setParameter("brokerUserId", (Object)link.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + link.getIdentityProvider() + ", userId=" + link.getUserId() + ", results=" + results);
        }
        return (String)results.get(0);
    }

    public void addFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel link) {
        this.createIndex(realm, userId);
        BrokerLinkEntity entity = new BrokerLinkEntity();
        entity.setRealmId(realm.getId());
        entity.setUserId(userId);
        entity.setBrokerUserId(link.getUserId());
        entity.setIdentityProvider(link.getIdentityProvider());
        entity.setToken(link.getToken());
        entity.setBrokerUserName(link.getUserName());
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)entity);
    }

    public boolean removeFederatedIdentity(RealmModel realm, String userId, String socialProvider) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, socialProvider);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    private BrokerLinkEntity getBrokerLinkEntity(RealmModel realm, String userId, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUserAndProvider", BrokerLinkEntity.class).setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (BrokerLinkEntity)results.get(0) : null;
    }

    public void updateFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel model) {
        this.createIndex(realm, userId);
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, model.getIdentityProvider());
        if (entity == null) {
            return;
        }
        entity.setBrokerUserName(model.getUserName());
        entity.setBrokerUserId(model.getUserId());
        entity.setToken(model.getToken());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(String userId, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUser", BrokerLinkEntity.class).setParameter("userId", (Object)userId);
        List results = query.getResultList();
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        for (BrokerLinkEntity entity : results) {
            FederatedIdentityModel model = new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken());
            set.add(model);
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(String userId, String socialProvider, RealmModel realm) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, socialProvider);
        if (entity == null) {
            return null;
        }
        return new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken());
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.createIndex(realm, userId);
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + userId + "]");
        }
        consentEntity = new FederatedUserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUserId(userId);
        consentEntity.setClientId(clientId);
        consentEntity.setRealmId(realm.getId());
        consentEntity.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        FederatedUserConsentEntity entity = this.getGrantedConsentEntity(userId, clientInternalId);
        return this.toConsentModel(realm, entity);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("userFederatedConsentsByUser", FederatedUserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        ArrayList<UserConsentModel> consents = new ArrayList<UserConsentModel>();
        for (FederatedUserConsentEntity entity : results) {
            UserConsentModel model = this.toConsentModel(realm, entity);
            consents.add(model);
        }
        return consents;
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.createIndex(realm, userId);
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientInternalId);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private FederatedUserConsentEntity getGrantedConsentEntity(String userId, String clientId) {
        TypedQuery query = this.em.createNamedQuery("userFederatedConsentByUserAndClient", FederatedUserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("clientId", (Object)clientId);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + userId + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (FederatedUserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, FederatedUserConsentEntity entity) {
        Collection<FederatedUserConsentProtocolMapperEntity> grantedProtocolMapperEntities;
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        Collection<FederatedUserConsentRoleEntity> grantedRoleEntities = entity.getGrantedRoles();
        if (grantedRoleEntities != null) {
            for (FederatedUserConsentRoleEntity grantedRole : grantedRoleEntities) {
                RoleModel grantedRoleModel = realm.getRoleById(grantedRole.getRoleId());
                if (grantedRoleModel == null) continue;
                model.addGrantedRole(grantedRoleModel);
            }
        }
        if ((grantedProtocolMapperEntities = entity.getGrantedProtocolMappers()) != null) {
            for (FederatedUserConsentProtocolMapperEntity grantedProtMapper : grantedProtocolMapperEntities) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(grantedProtMapper.getProtocolMapperId());
                model.addGrantedProtocolMapper(protocolMapper);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(FederatedUserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<FederatedUserConsentProtocolMapperEntity> grantedProtocolMapperEntities = consentEntity.getGrantedProtocolMappers();
        HashSet<FederatedUserConsentProtocolMapperEntity> mappersToRemove = new HashSet<FederatedUserConsentProtocolMapperEntity>(grantedProtocolMapperEntities);
        for (ProtocolMapperModel protocolMapper : consentModel.getGrantedProtocolMappers()) {
            FederatedUserConsentProtocolMapperEntity grantedProtocolMapperEntity = new FederatedUserConsentProtocolMapperEntity();
            grantedProtocolMapperEntity.setUserConsent(consentEntity);
            grantedProtocolMapperEntity.setProtocolMapperId(protocolMapper.getId());
            if (!grantedProtocolMapperEntities.contains(grantedProtocolMapperEntity)) {
                this.em.persist((Object)grantedProtocolMapperEntity);
                this.em.flush();
                grantedProtocolMapperEntities.add(grantedProtocolMapperEntity);
                continue;
            }
            mappersToRemove.remove(grantedProtocolMapperEntity);
        }
        for (FederatedUserConsentProtocolMapperEntity toRemove : mappersToRemove) {
            grantedProtocolMapperEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        Collection<FederatedUserConsentRoleEntity> grantedRoleEntities = consentEntity.getGrantedRoles();
        HashSet<FederatedUserConsentRoleEntity> rolesToRemove = new HashSet<FederatedUserConsentRoleEntity>(grantedRoleEntities);
        for (RoleModel role : consentModel.getGrantedRoles()) {
            FederatedUserConsentRoleEntity consentRoleEntity = new FederatedUserConsentRoleEntity();
            consentRoleEntity.setUserConsent(consentEntity);
            consentRoleEntity.setRoleId(role.getId());
            if (!grantedRoleEntities.contains(consentRoleEntity)) {
                this.em.persist((Object)consentRoleEntity);
                this.em.flush();
                grantedRoleEntities.add(consentRoleEntity);
                continue;
            }
            rolesToRemove.remove(consentRoleEntity);
        }
        for (FederatedUserConsentRoleEntity toRemove : rolesToRemove) {
            grantedRoleEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        this.em.flush();
    }

    public Set<GroupModel> getGroups(RealmModel realm, String userId) {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        TypedQuery query = this.em.createNamedQuery("feduserGroupMembership", FederatedUserGroupMembershipEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        if (results.size() == 0) {
            return set;
        }
        for (FederatedUserGroupMembershipEntity entity : results) {
            GroupModel group = realm.getGroupById(entity.getGroupId());
            set.add(group);
        }
        return set;
    }

    public void joinGroup(RealmModel realm, String userId, GroupModel group) {
        this.createIndex(realm, userId);
        FederatedUserGroupMembershipEntity entity = new FederatedUserGroupMembershipEntity();
        entity.setUserId(userId);
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        entity.setGroupId(group.getId());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
    }

    public void leaveGroup(RealmModel realm, String userId, GroupModel group) {
        if (userId == null || group == null) {
            return;
        }
        TypedQuery query1 = this.em.createNamedQuery("feduserMemberOf", FederatedUserGroupMembershipEntity.class);
        query1.setParameter("userId", (Object)userId);
        query1.setParameter("groupId", (Object)group.getId());
        TypedQuery query = query1;
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (FederatedUserGroupMembershipEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public List<String> getMembership(RealmModel realm, GroupModel group, int firstResult, int max) {
        TypedQuery query = this.em.createNamedQuery("fedgroupMembership", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("groupId", (Object)group.getId());
        query.setFirstResult(firstResult);
        query.setMaxResults(max);
        return query.getResultList();
    }

    public Set<String> getRequiredActions(RealmModel realm, String userId) {
        HashSet<String> set = new HashSet<String>();
        List<FederatedUserRequiredActionEntity> values = this.getRequiredActionEntities(realm, userId);
        for (FederatedUserRequiredActionEntity entity : values) {
            set.add(entity.getAction());
        }
        return set;
    }

    private List<FederatedUserRequiredActionEntity> getRequiredActionEntities(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("getFederatedUserRequiredActionsByUser", FederatedUserRequiredActionEntity.class).setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId());
        return query.getResultList();
    }

    public void addRequiredAction(RealmModel realm, String userId, String action) {
        this.createIndex(realm, userId);
        FederatedUserRequiredActionEntity entity = new FederatedUserRequiredActionEntity();
        entity.setUserId(userId);
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        entity.setAction(action);
        this.em.persist((Object)entity);
    }

    public void removeRequiredAction(RealmModel realm, String userId, String action) {
        List<FederatedUserRequiredActionEntity> values = this.getRequiredActionEntities(realm, userId);
        for (FederatedUserRequiredActionEntity entity : values) {
            if (!action.equals(entity.getAction())) continue;
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public void grantRole(RealmModel realm, String userId, RoleModel role) {
        this.createIndex(realm, userId);
        FederatedUserRoleMappingEntity entity = new FederatedUserRoleMappingEntity();
        entity.setUserId(userId);
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        entity.setRealmId(realm.getId());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
    }

    public Set<RoleModel> getRoleMappings(RealmModel realm, String userId) {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        if (results.size() == 0) {
            return set;
        }
        for (FederatedUserRoleMappingEntity entity : results) {
            RoleModel role = realm.getRoleById(entity.getRoleId());
            set.add(role);
        }
        return set;
    }

    public void deleteRoleMapping(RealmModel realm, String userId, RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        for (FederatedUserRoleMappingEntity entity : results) {
            if (!entity.getRoleId().equals(role.getId())) continue;
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public void updateCredential(RealmModel realm, String userId, CredentialModel cred) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)cred.getId());
        if (entity == null) {
            return;
        }
        this.createIndex(realm, userId);
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (!entity.getCredentialAttributes().isEmpty() || cred.getConfig() != null && !cred.getConfig().isEmpty()) {
            MultivaluedHashMap attrs = new MultivaluedHashMap();
            MultivaluedHashMap config = cred.getConfig();
            if (config == null) {
                config = new MultivaluedHashMap();
            }
            Iterator<FederatedUserCredentialAttributeEntity> it = entity.getCredentialAttributes().iterator();
            while (it.hasNext()) {
                FederatedUserCredentialAttributeEntity attr = it.next();
                List values = config.getList((Object)attr.getName());
                if (values == null || !values.contains(attr.getValue())) {
                    this.em.remove((Object)attr);
                    it.remove();
                    continue;
                }
                attrs.add((Object)attr.getName(), (Object)attr.getValue());
            }
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                List attrValues = attrs.getList((Object)key);
                for (String val : values) {
                    if (attrValues != null && attrValues.contains(val)) continue;
                    FederatedUserCredentialAttributeEntity attr = new FederatedUserCredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
    }

    public CredentialModel createCredential(RealmModel realm, String userId, CredentialModel cred) {
        this.createIndex(realm, userId);
        FederatedUserCredentialEntity entity = new FederatedUserCredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        entity.setUserId(userId);
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)entity);
        MultivaluedHashMap config = cred.getConfig();
        if (config != null && !config.isEmpty()) {
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                for (String val : values) {
                    FederatedUserCredentialAttributeEntity attr = new FederatedUserCredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, String userId, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, String userId, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    protected CredentialModel toModel(FederatedUserCredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setValue(entity.getValue());
        model.setAlgorithm(entity.getAlgorithm());
        model.setSalt(entity.getSalt());
        model.setPeriod(entity.getPeriod());
        model.setCounter(entity.getCounter());
        model.setCreatedDate(entity.getCreatedDate());
        model.setDevice(entity.getDevice());
        model.setDigits(entity.getDigits());
        model.setHashIterations(entity.getHashIterations());
        MultivaluedHashMap config = new MultivaluedHashMap();
        model.setConfig(config);
        for (FederatedUserCredentialAttributeEntity attr : entity.getCredentialAttributes()) {
            config.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return model;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUser", FederatedUserCredentialEntity.class).setParameter("userId", (Object)userId);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (FederatedUserCredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, String userId, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUserAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("userId", (Object)userId);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (FederatedUserCredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, String userId, String name, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByNameAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("device", (Object)name).setParameter("userId", (Object)userId);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return this.toModel((FederatedUserCredentialEntity)results.get(0));
    }

    public List<String> getStoredUsers(RealmModel realm, int first, int max) {
        TypedQuery query = this.em.createNamedQuery("getFederatedUserIds", String.class).setParameter("realmId", (Object)realm.getId()).setFirstResult(first);
        if (max > 0) {
            query.setMaxResults(max);
        }
        return query.getResultList();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.updateCredential(realm, user.getId(), cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.createCredential(realm, user.getId(), cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.removeStoredCredential(realm, user.getId(), id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoredCredentialById(realm, user.getId(), id);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.getStoredCredentials(realm, user.getId());
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        return this.getStoredCredentialsByType(realm, user.getId(), type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoredCredentialByNameAndType(realm, user.getId(), name, type);
    }

    public int getStoredUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getFederatedUserCount").setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteFederatedUserConsentRolesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteBrokerLinkByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedCredentialAttributeByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserFederatedAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentRolesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByProtocolMapper").setParameter("protocolMapperId", (Object)protocolMapper.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, UserModel user) {
        this.em.createNamedQuery("deleteBrokerLinkByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserFederatedAttributesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentRolesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedCredentialAttributeByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserCredentialByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRequiredActionsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ComponentModel model) {
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.em.createNamedQuery("deleteBrokerLinkByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedAttributesByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedCredentialAttributeByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserCredentialsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRequiredActionsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUsersByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
    }
}

