/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.util;

import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.ConfigHandler;
import org.keycloak.client.registration.cli.config.ConfigUpdateOperation;
import org.keycloak.client.registration.cli.config.InMemoryConfigHandler;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.representations.AccessTokenResponse;

public class ConfigUtil {
    public static final String DEFAULT_CONFIG_FILE_STRING = OsUtil.OS_ARCH.isWindows() ? "%HOMEDRIVE%%HOMEPATH%\\.keycloak\\kcreg.config" : "~/.keycloak/kcreg.config";
    public static final String DEFAULT_CONFIG_FILE_PATH = System.getProperty("user.home") + "/.keycloak/kcreg.config";
    private static ConfigHandler handler;

    public static ConfigHandler getHandler() {
        return handler;
    }

    public static void setHandler(ConfigHandler handler) {
        ConfigUtil.handler = handler;
    }

    public static String getRegistrationToken(RealmConfigData data, String clientId) {
        String token = data.getClients().get(clientId);
        return token == null || token.length() == 0 ? null : token;
    }

    public static void setRegistrationToken(RealmConfigData data, String clientId, String token) {
        data.getClients().put(clientId, token == null ? "" : token);
    }

    public static void saveTokens(AccessTokenResponse tokens, String endpoint, String realm, String clientId, String signKey, Long sigExpiresAt, String secret) {
        handler.saveMergeConfig(config -> {
            config.setServerUrl(endpoint);
            config.setRealm(realm);
            RealmConfigData realmConfig = config.ensureRealmConfigData(endpoint, realm);
            realmConfig.setToken(tokens.getToken());
            realmConfig.setRefreshToken(tokens.getRefreshToken());
            realmConfig.setSigningToken(signKey);
            realmConfig.setSecret(secret);
            realmConfig.setExpiresAt(System.currentTimeMillis() + tokens.getExpiresIn() * 1000L);
            realmConfig.setRefreshExpiresAt(tokens.getRefreshExpiresIn() == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + tokens.getRefreshExpiresIn() * 1000L);
            realmConfig.setSigExpiresAt(sigExpiresAt);
            realmConfig.setClientId(clientId);
        });
    }

    public static void checkServerInfo(ConfigData config) {
        if (config.getServerUrl() == null || config.getRealm() == null) {
            throw new RuntimeException("No server or realm specified. Use --server, --realm, or '" + OsUtil.CMD + " config credentials'.");
        }
    }

    public static void checkAuthInfo(ConfigData config) {
        ConfigUtil.checkServerInfo(config);
    }

    public static boolean credentialsAvailable(ConfigData config) {
        return config.getServerUrl() != null && config.getRealm() != null && config.sessionRealmConfigData() != null && config.sessionRealmConfigData().getRefreshToken() != null;
    }

    public static ConfigData loadConfig() {
        if (handler == null) {
            throw new RuntimeException("No ConfigHandler set");
        }
        return handler.loadConfig();
    }

    public static void saveMergeConfig(ConfigUpdateOperation op) {
        if (handler == null) {
            throw new RuntimeException("No ConfigHandler set");
        }
        handler.saveMergeConfig(op);
    }

    public static void setupInMemoryHandler(ConfigData config) {
        InMemoryConfigHandler memhandler = null;
        if (handler instanceof InMemoryConfigHandler) {
            memhandler = (InMemoryConfigHandler)handler;
        } else {
            memhandler = new InMemoryConfigHandler();
            handler = memhandler;
        }
        memhandler.setConfigData(config);
    }
}

