/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;

public class AddUserExample {
    public static void main(String[] args) {
        Settings settings = new SettingsBuilder().logging(false).readInputrc(false).disableCompletion(true).disableHistory(true).enableAlias(false).enableExport(false).create();
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(AddUserCommand.class).create();
        AeshConsoleImpl console = (AeshConsoleImpl)new AeshConsoleBuilder().settings(settings).commandRegistry(registry).prompt(new Prompt("")).create();
        console.start();
        console.execute("add-user " + Arrays.toString(args));
    }

    @CommandDefinition(name="add-user", description="[options...]")
    public static class AddUserCommand
    implements Command {
        @Option(shortName=114, hasValue=true, description="Name of realm to add user to")
        private String realm;
        @Option(shortName=117, hasValue=true, description="Name of the user")
        private String user;
        @Option(shortName=112, hasValue=true, description="Password of the user")
        private String password;
        @Option(hasValue=true, description="Roles to add to the user")
        private String roles;
        @Option(hasValue=true, description="Hash iterations")
        private int iterations;
        @Option(hasValue=false, description="Enable domain mode")
        private boolean domain;
        @Option(hasValue=false, description="Add user to underlying container. For usage use '--container --help'")
        private boolean container;
        @Option(hasValue=true, description="Define the location of the server config directory")
        private String sc;
        @Option(hasValue=true, description="Define the location of the domain config directory")
        private String dc;
        @Option(shortName=104, hasValue=false, description="Display this help and exit")
        private boolean help;

        public CommandResult execute(CommandInvocation commandInvocation) throws InterruptedException {
            if (this.help) {
                commandInvocation.getHelpInfo("add-user");
            }
            this.exit(commandInvocation);
            return CommandResult.SUCCESS;
        }

        private void exit(CommandInvocation commandInvocation) {
            commandInvocation.stop();
        }

        public String getRealm() {
            return this.realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getRoles() {
            return this.roles;
        }

        public int getIterations() {
            return this.iterations;
        }

        public boolean isDomain() {
            return this.domain;
        }

        public boolean isContainer() {
            return this.container;
        }

        public String getSc() {
            return this.sc;
        }

        public String getDc() {
            return this.dc;
        }

        public boolean isHelp() {
            return this.help;
        }
    }
}

