/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.representations.idm.authorization.DecisionStrategy;

public abstract class DecisionResultCollector
implements Decision<DefaultEvaluation> {
    private Map<ResourcePermission, Result> results = new HashMap<ResourcePermission, Result>();

    @Override
    public void onDecision(DefaultEvaluation evaluation) {
        Policy parentPolicy = evaluation.getParentPolicy();
        if (parentPolicy != null) {
            this.results.computeIfAbsent(evaluation.getPermission(), Result::new).policy(parentPolicy).policy(evaluation.getPolicy()).setStatus(evaluation.getEffect());
        } else {
            this.results.computeIfAbsent(evaluation.getPermission(), Result::new).setStatus(evaluation.getEffect());
        }
    }

    @Override
    public void onComplete() {
        for (Result result : this.results.values()) {
            for (Result.PolicyResult policyResult2 : result.getResults()) {
                if (this.isGranted(policyResult2)) {
                    policyResult2.setStatus(Decision.Effect.PERMIT);
                    continue;
                }
                policyResult2.setStatus(Decision.Effect.DENY);
            }
            if (result.getResults().stream().filter(policyResult -> Decision.Effect.DENY.equals((Object)policyResult.getStatus())).count() > 0L) {
                result.setStatus(Decision.Effect.DENY);
                continue;
            }
            result.setStatus(Decision.Effect.PERMIT);
        }
        this.onComplete(this.results.values().stream().collect(Collectors.toList()));
    }

    protected abstract void onComplete(List<Result> var1);

    private boolean isGranted(Result.PolicyResult policyResult) {
        List<Result.PolicyResult> values = policyResult.getAssociatedPolicies();
        int grantCount = 0;
        int denyCount = policyResult.getPolicy().getAssociatedPolicies().size();
        for (Result.PolicyResult decision : values) {
            if (!decision.getStatus().equals((Object)Decision.Effect.PERMIT)) continue;
            ++grantCount;
            --denyCount;
        }
        Policy policy = policyResult.getPolicy();
        DecisionStrategy decisionStrategy = policy.getDecisionStrategy();
        if (decisionStrategy == null) {
            decisionStrategy = DecisionStrategy.UNANIMOUS;
        }
        if (DecisionStrategy.AFFIRMATIVE.equals((Object)decisionStrategy) && grantCount > 0) {
            return true;
        }
        if (DecisionStrategy.UNANIMOUS.equals((Object)decisionStrategy) && denyCount == 0) {
            return true;
        }
        return DecisionStrategy.CONSENSUS.equals((Object)decisionStrategy) && grantCount > denyCount;
    }
}

