/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin.representation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class PolicyEvaluationResponse {
    private List<EvaluationResultRepresentation> results;
    private boolean entitlements;
    private Decision.Effect status;
    private AccessToken rpt;

    private PolicyEvaluationResponse() {
    }

    public static PolicyEvaluationResponse build(List<Result> results, ResourceServer resourceServer, AuthorizationProvider authorization, KeycloakIdentity identity) {
        PolicyEvaluationResponse response = new PolicyEvaluationResponse();
        ArrayList<EvaluationResultRepresentation> resultsRep = new ArrayList<EvaluationResultRepresentation>();
        AccessToken accessToken = identity.getAccessToken();
        AccessToken.Authorization authorizationData = new AccessToken.Authorization();
        authorizationData.setPermissions(Permissions.allPermits(results, authorization, resourceServer));
        accessToken.setAuthorization(authorizationData);
        response.rpt = accessToken;
        response.status = results.stream().anyMatch(evaluationResult -> evaluationResult.getEffect().equals((Object)Decision.Effect.DENY)) ? Decision.Effect.DENY : Decision.Effect.PERMIT;
        for (Result result : results) {
            ResourceRepresentation resource;
            EvaluationResultRepresentation rep = new EvaluationResultRepresentation();
            rep.setStatus(result.getEffect());
            resultsRep.add(rep);
            if (result.getPermission().getResource() != null) {
                resource = new ResourceRepresentation();
                resource.setId(result.getPermission().getResource().getId());
                resource.setName(result.getPermission().getResource().getName());
                rep.setResource(resource);
            } else {
                resource = new ResourceRepresentation();
                resource.setName("Any Resource with Scopes " + result.getPermission().getScopes().stream().map(Scope::getName).collect(Collectors.toList()));
                rep.setResource(resource);
            }
            rep.setScopes(result.getPermission().getScopes().stream().map(scope -> {
                ScopeRepresentation representation = new ScopeRepresentation();
                representation.setId(scope.getId());
                representation.setName(scope.getName());
                return representation;
            }).collect(Collectors.toList()));
            ArrayList<PolicyResultRepresentation> policies = new ArrayList<PolicyResultRepresentation>();
            for (Result.PolicyResult policy : result.getResults()) {
                policies.add(PolicyEvaluationResponse.toRepresentation(policy, authorization));
            }
            rep.setPolicies(policies);
        }
        resultsRep.sort(Comparator.comparing(o -> o.getResource().getName()));
        HashMap groupedResults = new HashMap();
        resultsRep.forEach(evaluationResultRepresentation -> {
            List<ScopeRepresentation> currentScopes;
            List<ScopeRepresentation> scopes;
            EvaluationResultRepresentation result = (EvaluationResultRepresentation)groupedResults.get(evaluationResultRepresentation.getResource().getId());
            ResourceRepresentation resource = evaluationResultRepresentation.getResource();
            if (result == null) {
                groupedResults.put(resource.getId(), evaluationResultRepresentation);
                result = evaluationResultRepresentation;
            }
            if (result.getStatus().equals((Object)Decision.Effect.PERMIT) || evaluationResultRepresentation.getStatus().equals((Object)Decision.Effect.PERMIT) && result.getStatus().equals((Object)Decision.Effect.DENY)) {
                result.setStatus(Decision.Effect.PERMIT);
            }
            if ((scopes = result.getScopes()) == null) {
                scopes = new ArrayList<ScopeRepresentation>();
                result.setScopes(scopes);
            }
            if ((currentScopes = evaluationResultRepresentation.getScopes()) != null) {
                final List<ScopeRepresentation> allowedScopes = result.getAllowedScopes();
                for (final ScopeRepresentation scope : currentScopes) {
                    if (!scopes.contains(scope)) {
                        scopes.add(scope);
                    }
                    if (evaluationResultRepresentation.getStatus().equals((Object)Decision.Effect.PERMIT)) {
                        if (allowedScopes.contains(scope)) continue;
                        allowedScopes.add(scope);
                        continue;
                    }
                    evaluationResultRepresentation.getPolicies().forEach(new Consumer<PolicyResultRepresentation>(){

                        @Override
                        public void accept(PolicyResultRepresentation policyResultRepresentation) {
                            if (policyResultRepresentation.getStatus().equals((Object)Decision.Effect.PERMIT) && !allowedScopes.contains(scope)) {
                                allowedScopes.add(scope);
                            }
                        }
                    });
                }
                result.setAllowedScopes(allowedScopes);
            }
            if (resource.getId() != null) {
                if (!scopes.isEmpty()) {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName() + " with scopes " + scopes.stream().flatMap(scopeRepresentation -> Arrays.asList(scopeRepresentation.getName()).stream()).collect(Collectors.toList()));
                } else {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName());
                }
            } else {
                result.getResource().setName("Any Resource with Scopes " + scopes.stream().flatMap(scopeRepresentation -> Arrays.asList(scopeRepresentation.getName()).stream()).collect(Collectors.toList()));
            }
            List<PolicyResultRepresentation> policies = result.getPolicies();
            for (PolicyResultRepresentation policy : new ArrayList<PolicyResultRepresentation>(evaluationResultRepresentation.getPolicies())) {
                if (!policies.contains(policy)) {
                    policies.add(policy);
                } else {
                    policy = policies.get(policies.indexOf(policy));
                }
                if (!policy.getStatus().equals((Object)Decision.Effect.DENY)) continue;
                Policy policyModel = authorization.getStoreFactory().getPolicyStore().findById(policy.getPolicy().getId(), resourceServer.getId());
                for (ScopeRepresentation scope : policyModel.getScopes().stream().map(scopeModel -> ModelToRepresentation.toRepresentation((Scope)scopeModel, (AuthorizationProvider)authorization)).collect(Collectors.toList())) {
                    if (policy.getScopes().contains(scope) || !policyModel.getScopes().stream().filter(policyScope -> policyScope.getId().equals(scope.getId())).findFirst().isPresent()) continue;
                    result.getAllowedScopes().remove(scope);
                    policy.getScopes().add(scope);
                }
            }
        });
        response.results = groupedResults.values().stream().collect(Collectors.toList());
        return response;
    }

    private static PolicyResultRepresentation toRepresentation(Result.PolicyResult policy, AuthorizationProvider authorization) {
        PolicyResultRepresentation policyResultRep = new PolicyResultRepresentation();
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setId(policy.getPolicy().getId());
        representation.setName(policy.getPolicy().getName());
        representation.setType(policy.getPolicy().getType());
        representation.setDecisionStrategy(policy.getPolicy().getDecisionStrategy());
        policyResultRep.setPolicy(representation);
        policyResultRep.setStatus(policy.getStatus());
        policyResultRep.setAssociatedPolicies(policy.getAssociatedPolicies().stream().map(result -> PolicyEvaluationResponse.toRepresentation(result, authorization)).collect(Collectors.toList()));
        return policyResultRep;
    }

    public List<EvaluationResultRepresentation> getResults() {
        return this.results;
    }

    public Decision.Effect getStatus() {
        return this.status;
    }

    public boolean isEntitlements() {
        return this.entitlements;
    }

    public AccessToken getRpt() {
        return this.rpt;
    }

    public static class PolicyResultRepresentation {
        private PolicyRepresentation policy;
        private Decision.Effect status;
        private List<PolicyResultRepresentation> associatedPolicies;
        private List<ScopeRepresentation> scopes = new ArrayList<ScopeRepresentation>();

        public PolicyRepresentation getPolicy() {
            return this.policy;
        }

        public void setPolicy(PolicyRepresentation policy) {
            this.policy = policy;
        }

        public Decision.Effect getStatus() {
            return this.status;
        }

        public void setStatus(Decision.Effect status) {
            this.status = status;
        }

        public List<PolicyResultRepresentation> getAssociatedPolicies() {
            return this.associatedPolicies;
        }

        public void setAssociatedPolicies(List<PolicyResultRepresentation> associatedPolicies) {
            this.associatedPolicies = associatedPolicies;
        }

        public int hashCode() {
            return this.policy.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PolicyResultRepresentation policy = (PolicyResultRepresentation)o;
            return this.policy.equals((Object)policy.getPolicy());
        }

        public void setScopes(List<ScopeRepresentation> scopes) {
            this.scopes = scopes;
        }

        public List<ScopeRepresentation> getScopes() {
            return this.scopes;
        }
    }

    public static class EvaluationResultRepresentation {
        private ResourceRepresentation resource;
        private List<ScopeRepresentation> scopes;
        private List<PolicyResultRepresentation> policies;
        private Decision.Effect status;
        private List<ScopeRepresentation> allowedScopes = new ArrayList<ScopeRepresentation>();

        public void setResource(ResourceRepresentation resource) {
            this.resource = resource;
        }

        public ResourceRepresentation getResource() {
            return this.resource;
        }

        public void setScopes(List<ScopeRepresentation> scopes) {
            this.scopes = scopes;
        }

        public List<ScopeRepresentation> getScopes() {
            return this.scopes;
        }

        public void setPolicies(List<PolicyResultRepresentation> policies) {
            this.policies = policies;
        }

        public List<PolicyResultRepresentation> getPolicies() {
            return this.policies;
        }

        public void setStatus(Decision.Effect status) {
            this.status = status;
        }

        public Decision.Effect getStatus() {
            return this.status;
        }

        public void setAllowedScopes(List<ScopeRepresentation> allowedScopes) {
            this.allowedScopes = allowedScopes;
        }

        public List<ScopeRepresentation> getAllowedScopes() {
            return this.allowedScopes;
        }
    }
}

