/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBList;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;

public class BasicDBListToSetMapper
implements Mapper<BasicDBList, Set> {
    private final MapperRegistry mapperRegistry;

    public BasicDBListToSetMapper(MapperRegistry mapperRegistry) {
        this.mapperRegistry = mapperRegistry;
    }

    @Override
    public Set convertObject(MapperContext<BasicDBList, Set> context) {
        BasicDBList dbList = context.getObjectToConvert();
        HashSet appObjects = new HashSet();
        Class expectedListElementType = (Class)context.getGenericTypes().get(0);
        for (Object dbObject : dbList) {
            MapperContext newContext = new MapperContext(dbObject, expectedListElementType, null);
            appObjects.add(this.mapperRegistry.convertDBObjectToApplicationObject(newContext));
        }
        return appObjects;
    }

    @Override
    public Class<? extends BasicDBList> getTypeOfObjectToConvert() {
        return BasicDBList.class;
    }

    @Override
    public Class<Set> getExpectedReturnType() {
        return Set.class;
    }
}

