/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils.reflection;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.keycloak.models.utils.reflection.PropertyCriteria;

public class NamedPropertyCriteria
implements PropertyCriteria {
    private final String[] propertyNames;

    public NamedPropertyCriteria(String ... propertyNames) {
        this.propertyNames = propertyNames;
    }

    public boolean fieldMatches(Field f) {
        for (String propertyName : this.propertyNames) {
            if (!propertyName.equals(f.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean methodMatches(Method m) {
        String[] validPrefix = new String[]{"get", "is"};
        for (String propertyName : this.propertyNames) {
            for (String prefix : validPrefix) {
                if (!m.getName().startsWith(prefix) || !Introspector.decapitalize(m.getName().substring(prefix.length())).equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }
}

