/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.Collection;
import org.drools.core.command.CommandService;
import org.drools.core.command.runtime.GetFactCountInEntryPointCommand;
import org.drools.core.command.runtime.rule.DeleteFromEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandleInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectsInEntryPointCommand;
import org.drools.core.command.runtime.rule.InsertObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.UpdateInEntryPointCommand;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class CommandBasedEntryPoint
implements EntryPoint {
    private final CommandService commandService;
    private final String entryPoint;

    public CommandBasedEntryPoint(CommandService commandService, String entryPoint) {
        this.commandService = commandService;
        this.entryPoint = entryPoint;
    }

    public String getEntryPointId() {
        return this.entryPoint;
    }

    public FactHandle insert(Object object) {
        return (FactHandle)this.commandService.execute(new InsertObjectInEntryPointCommand(object, this.entryPoint));
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.commandService.execute(new DeleteFromEntryPointCommand(handle, this.entryPoint));
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.commandService.execute(new DeleteFromEntryPointCommand(handle, this.entryPoint, fhState));
    }

    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateInEntryPointCommand(handle, object, this.entryPoint));
    }

    public FactHandle getFactHandle(Object object) {
        return (FactHandle)this.commandService.execute(new GetFactHandleInEntryPointCommand(object, this.entryPoint));
    }

    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectInEntryPointCommand(factHandle, this.entryPoint));
    }

    public Collection<? extends Object> getObjects() {
        return (Collection)this.commandService.execute(new GetObjectsInEntryPointCommand(null, this.entryPoint));
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetObjectsInEntryPointCommand(filter, this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return (Collection)this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint, filter));
    }

    public long getFactCount() {
        return (Long)this.commandService.execute(new GetFactCountInEntryPointCommand(this.entryPoint));
    }
}

