/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.core.command.CommandService;
import org.drools.core.command.GetSessionClockCommand;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.command.runtime.AddEventListenerCommand;
import org.drools.core.command.runtime.DestroySessionCommand;
import org.drools.core.command.runtime.DisposeCommand;
import org.drools.core.command.runtime.GetCalendarsCommand;
import org.drools.core.command.runtime.GetChannelsCommand;
import org.drools.core.command.runtime.GetEnvironmentCommand;
import org.drools.core.command.runtime.GetFactCountCommand;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.GetGlobalsCommand;
import org.drools.core.command.runtime.GetIdCommand;
import org.drools.core.command.runtime.GetKnowledgeBaseCommand;
import org.drools.core.command.runtime.RegisterChannelCommand;
import org.drools.core.command.runtime.RemoveEventListenerCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.UnregisterChannelCommand;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.CreateCorrelatedProcessInstanceCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetProcessEventListenersCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceByCorrelationKeyCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetProcessInstancesCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.core.command.runtime.rule.ClearAgendaCommand;
import org.drools.core.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.core.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.GetAgendaEventListenersCommand;
import org.drools.core.command.runtime.rule.GetEntryPointCommand;
import org.drools.core.command.runtime.rule.GetEntryPointsCommand;
import org.drools.core.command.runtime.rule.GetFactHandleCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.GetObjectsCommand;
import org.drools.core.command.runtime.rule.GetRuleRuntimeEventListenersCommand;
import org.drools.core.command.runtime.rule.HaltCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.rule.EntryPointId;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.rule.ActivationGroup;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.AgendaGroup;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.RuleFlowGroup;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CommandBasedStatefulKnowledgeSession
extends AbstractRuntime
implements StatefulKnowledgeSession,
CorrelationAwareProcessRuntime {
    private CommandService commandService;
    private transient WorkItemManager workItemManager;
    private transient Agenda agenda;

    public CommandBasedStatefulKnowledgeSession(CommandService commandService) {
        this.commandService = commandService;
    }

    @Deprecated
    public int getId() {
        return ((Long)this.commandService.execute(new GetIdCommand())).intValue();
    }

    public long getIdentifier() {
        return (Long)this.commandService.execute(new GetIdCommand());
    }

    public ProcessInstance getProcessInstance(long id) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance getProcessInstance(long id, boolean readOnly) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        command.setReadOnly(readOnly);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public void abortProcessInstance(long id) {
        AbortProcessInstanceCommand command = new AbortProcessInstanceCommand();
        command.setProcessInstanceId(id);
        this.commandService.execute(command);
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return (Collection)this.commandService.execute(new GetProcessInstancesCommand());
    }

    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = new WorkItemManager(){

                public void completeWorkItem(long id, Map<String, Object> results) {
                    CompleteWorkItemCommand command = new CompleteWorkItemCommand();
                    command.setWorkItemId(id);
                    command.setResults(results);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public void abortWorkItem(long id) {
                    AbortWorkItemCommand command = new AbortWorkItemCommand();
                    command.setWorkItemId(id);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
                    RegisterWorkItemHandlerCommand command = new RegisterWorkItemHandlerCommand();
                    command.setWorkItemName(workItemName);
                    command.setHandler(handler);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public WorkItem getWorkItem(long id) {
                    GetWorkItemCommand command = new GetWorkItemCommand();
                    command.setWorkItemId(id);
                    return (WorkItem)CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Set<WorkItem> getWorkItems() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAbortWorkItem(long id) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAddWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalExecuteWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void signalEvent(String type, Object event) {
                    SignalEventCommand command = new SignalEventCommand(type, event);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void signalEvent(String type, Object event, long processInstanceId) {
                    SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void dispose() {
                }
            };
        }
        return this.workItemManager;
    }

    public void signalEvent(String type, Object event) {
        SignalEventCommand command = new SignalEventCommand(type, event);
        this.commandService.execute(command);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
        this.commandService.execute(command);
    }

    public ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        StartProcessCommand command = new StartProcessCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        CreateProcessInstanceCommand command = new CreateProcessInstanceCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        StartProcessInstanceCommand command = new StartProcessInstanceCommand();
        command.setProcessInstanceId(processInstanceId);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public void dispose() {
        this.commandService.execute(new DisposeCommand());
    }

    public void destroy() {
        this.commandService.execute(new DestroySessionCommand(this.commandService));
    }

    public int fireAllRules() {
        return (Integer)this.commandService.execute(new FireAllRulesCommand());
    }

    public int fireAllRules(int max) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(max));
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(agendaFilter));
    }

    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(agendaFilter, max));
    }

    public void fireUntilHalt() {
        this.commandService.execute(new FireUntilHaltCommand());
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.commandService.execute(new FireUntilHaltCommand(agendaFilter));
    }

    public KnowledgeBase getKieBase() {
        return (KnowledgeBase)this.commandService.execute(new GetKnowledgeBaseCommand());
    }

    public void registerChannel(String name, Channel channel) {
        this.commandService.execute(new RegisterChannelCommand(name, channel));
    }

    public void unregisterChannel(String name) {
        this.commandService.execute(new UnregisterChannelCommand(name));
    }

    public Map<String, Channel> getChannels() {
        return (Map)this.commandService.execute(new GetChannelsCommand());
    }

    public Agenda getAgenda() {
        if (this.agenda == null) {
            this.agenda = new Agenda(){

                public void clear() {
                    ClearAgendaCommand command = new ClearAgendaCommand();
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public ActivationGroup getActivationGroup(final String name) {
                    return new ActivationGroup(){

                        public void clear() {
                            ClearActivationGroupCommand command = new ClearActivationGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }

                public AgendaGroup getAgendaGroup(final String name) {
                    return new AgendaGroup(){

                        public void clear() {
                            ClearAgendaGroupCommand command = new ClearAgendaGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }

                        public void setFocus() {
                            AgendaGroupSetFocusCommand command = new AgendaGroupSetFocusCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }
                    };
                }

                public RuleFlowGroup getRuleFlowGroup(final String name) {
                    return new RuleFlowGroup(){

                        public void clear() {
                            ClearRuleFlowGroupCommand command = new ClearRuleFlowGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }
            };
        }
        return this.agenda;
    }

    public FactHandle getFactHandle(Object object) {
        return (FactHandle)this.commandService.execute(new GetFactHandleCommand(object));
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return (Collection)this.commandService.execute(new GetFactHandlesCommand());
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetFactHandlesCommand(filter));
    }

    public Collection<? extends Object> getObjects() {
        return this.getObjects(null);
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        Collection result = (Collection)this.commandService.execute(new GetObjectsCommand(filter));
        return result;
    }

    public <T extends SessionClock> T getSessionClock() {
        return (T)((SessionClock)this.commandService.execute(new GetSessionClockCommand()));
    }

    public EntryPoint getEntryPoint(String name) {
        return (EntryPoint)this.commandService.execute(new GetEntryPointCommand(name));
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return (Collection)this.commandService.execute(new GetEntryPointsCommand());
    }

    public void halt() {
        this.commandService.execute(new HaltCommand());
    }

    public FactHandle insert(Object object) {
        return (FactHandle)this.commandService.execute(new InsertObjectCommand(object));
    }

    public void retract(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    public void delete(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.commandService.execute(new DeleteCommand(handle, fhState));
    }

    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateCommand(handle, object));
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public void addEventListener(AgendaEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return (Collection)this.commandService.execute(new GetAgendaEventListenersCommand());
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return (Collection)this.commandService.execute(new GetRuleRuntimeEventListenersCommand());
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public void addEventListener(ProcessEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return (Collection)this.commandService.execute(new GetProcessEventListenersCommand());
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public Object getGlobal(String identifier) {
        return this.commandService.execute(new GetGlobalCommand(identifier));
    }

    public void setGlobal(String identifier, Object object) {
        this.commandService.execute(new SetGlobalCommand(identifier, object));
    }

    public Globals getGlobals() {
        return (Globals)this.commandService.execute(new GetGlobalsCommand());
    }

    public Calendars getCalendars() {
        return (Calendars)this.commandService.execute(new GetCalendarsCommand());
    }

    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectCommand(factHandle));
    }

    public Environment getEnvironment() {
        return (Environment)this.commandService.execute(new GetEnvironmentCommand());
    }

    public <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    public QueryResults getQueryResults(String query, Object ... arguments) {
        QueryCommand cmd = new QueryCommand(null, query, arguments);
        return (QueryResults)this.commandService.execute(cmd);
    }

    public String getEntryPointId() {
        return EntryPointId.DEFAULT.getEntryPointId();
    }

    public long getFactCount() {
        return (Long)this.commandService.execute(new GetFactCountCommand());
    }

    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return null;
    }

    public KieSessionConfiguration getSessionConfiguration() {
        return ((KnowledgeCommandContext)this.commandService.getContext()).getKieSession().getSessionConfiguration();
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return (ProcessInstance)this.commandService.execute(new StartCorrelatedProcessCommand(processId, correlationKey, parameters));
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return (ProcessInstance)this.commandService.execute(new CreateCorrelatedProcessInstanceCommand(processId, correlationKey, parameters));
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return (ProcessInstance)this.commandService.execute(new GetProcessInstanceByCorrelationKeyCommand(correlationKey));
    }
}

