/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.kie.internal.concurrent.ExecutorProviderFactory;

public class SessionsCache {
    private final Map<SessionConfiguration, Queue<StatefulKnowledgeSessionImpl>> cleanSessions = new ConcurrentHashMap<SessionConfiguration, Queue<StatefulKnowledgeSessionImpl>>();
    private final boolean isAsync;

    SessionsCache(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public void store(StatefulKnowledgeSessionImpl session) {
        if (this.isAsync) {
            SessionResetterHolder.SESSION_RESETTER.enqueue(this, session);
        } else {
            session.reset();
            this.storeResettedSession(session);
        }
    }

    private void storeResettedSession(StatefulKnowledgeSessionImpl session) {
        Queue<StatefulKnowledgeSessionImpl> cache = this.cleanSessions.get(session.getSessionConfiguration());
        if (cache == null) {
            cache = new ConcurrentLinkedQueue<StatefulKnowledgeSessionImpl>();
            this.cleanSessions.put(session.getSessionConfiguration(), cache);
        }
        cache.offer(session);
    }

    public StatefulKnowledgeSessionImpl getCachedSession(SessionConfiguration config) {
        Queue<StatefulKnowledgeSessionImpl> cache = this.cleanSessions.get(config);
        return cache != null ? cache.poll() : null;
    }

    private static class SessionSlot {
        private final SessionsCache sessionsCache;
        private final StatefulKnowledgeSessionImpl session;

        private SessionSlot(SessionsCache sessionsCache, StatefulKnowledgeSessionImpl session) {
            this.sessionsCache = sessionsCache;
            this.session = session;
        }

        private void doReset() {
            this.session.reset();
            this.sessionsCache.storeResettedSession(this.session);
        }
    }

    private static class SessionResetter {
        private final Executor executor = ExecutorProviderFactory.getExecutorProvider().newSingleThreadExecutor();
        private final BlockingQueue<SessionSlot> dirtySessions = new ArrayBlockingQueue<SessionSlot>(20);

        private SessionResetter() {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                ((SessionSlot)SessionResetter.this.dirtySessions.take()).doReset();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            });
        }

        private void enqueue(SessionsCache sessionsCache, StatefulKnowledgeSessionImpl session) {
            this.dirtySessions.offer(new SessionSlot(sessionsCache, session));
        }
    }

    private static class SessionResetterHolder {
        private static final SessionResetter SESSION_RESETTER = new SessionResetter();

        private SessionResetterHolder() {
        }
    }
}

