/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.bitmask;

import java.io.Serializable;
import org.drools.core.util.bitmask.LongBitMask;
import org.drools.core.util.bitmask.OpenBitSet;

public interface BitMask
extends Serializable,
Cloneable {
    public BitMask set(int var1);

    public BitMask setAll(BitMask var1);

    public BitMask reset(int var1);

    public BitMask resetAll(BitMask var1);

    public boolean isSet(int var1);

    public boolean isAllSet();

    public boolean isEmpty();

    public boolean intersects(BitMask var1);

    public BitMask clone();

    public String getInstancingStatement();

    public static class Factory {
        public static BitMask getEmpty(int numBits) {
            return numBits <= 64 ? new LongBitMask() : new OpenBitSet(numBits);
        }

        public static BitMask getFull(int numBits) {
            if (numBits <= 64) {
                return new LongBitMask(-1L);
            }
            int nWords = numBits / 64 + 1;
            long[] bits = new long[nWords];
            for (int i = 0; i < bits.length; ++i) {
                bits[i] = -1L;
            }
            return new OpenBitSet(bits, nWords);
        }
    }
}

