/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.RealmAuth;

public class ScopeService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private ResourceServer resourceServer;

    public ScopeService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ScopeRepresentation scope) {
        this.auth.requireManage();
        Scope model = RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        scope.setId(model.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)scope).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ScopeRepresentation scope) {
        this.auth.requireManage();
        scope.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(scope.getId(), this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        List resources = storeFactory.getResourceStore().findByScope(Arrays.asList(id), this.resourceServer.getId());
        if (!resources.isEmpty()) {
            return ErrorResponse.exists("Scopes can not be removed while associated with resources.");
        }
        Scope scope = storeFactory.getScopeStore().findById(id, this.resourceServer.getId());
        if (scope == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByScopeIds(Arrays.asList(scope.getId()), this.resourceServer.getId());
        for (Policy policyModel : policies) {
            if (policyModel.getScopes().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.removeScope(scope);
        }
        storeFactory.getScopeStore().delete(id);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.auth.requireView();
        Scope model = this.authorization.getStoreFactory().getScopeStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model, (AuthorizationProvider)this.authorization)).build();
    }

    @Path(value="{id}/resources")
    @GET
    @Produces(value={"application/json"})
    public Response getResources(@PathParam(value="id") String id) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(storeFactory.getResourceStore().findByScope(Arrays.asList(model.getId()), this.resourceServer.getId()).stream().map(resource -> {
            ResourceRepresentation representation = new ResourceRepresentation();
            representation.setId(resource.getId());
            representation.setName(resource.getName());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="{id}/permissions")
    @GET
    @Produces(value={"application/json"})
    public Response getPermissions(@PathParam(value="id") String id) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(id, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        return Response.ok(policyStore.findByScopeIds(Arrays.asList(model.getId()), this.resourceServer.getId()).stream().map(policy -> {
            PolicyRepresentation representation = new PolicyRepresentation();
            representation.setId(policy.getId());
            representation.setName(policy.getName());
            representation.setType(policy.getType());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response find(@QueryParam(value="name") String name) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Scope model = storeFactory.getScopeStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model, (AuthorizationProvider)this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAll(@QueryParam(value="scopeId") String id, @QueryParam(value="name") String name, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        this.auth.requireView();
        if (deep == null) {
            deep = true;
        }
        HashMap<String, String[]> search = new HashMap<String, String[]>();
        if (id != null && !"".equals(id.trim())) {
            search.put("id", new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put("name", new String[]{name});
        }
        Boolean finalDeep = deep;
        return Response.ok(this.authorization.getStoreFactory().getScopeStore().findByResourceServer(search, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(scope -> ModelToRepresentation.toRepresentation((Scope)scope, (AuthorizationProvider)this.authorization, (boolean)finalDeep)).collect(Collectors.toList())).build();
    }
}

