/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class SessionMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private EmitValue emit = EmitValue.ENTITY;

    public SessionMapper(String realm) {
        this.realm = realm;
    }

    public static SessionMapper create(String realm) {
        return new SessionMapper(realm);
    }

    public SessionMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public void map(String key, SessionEntity e, Collector collector) {
        if (!this.realm.equals(e.getRealm())) {
            return;
        }
        switch (this.emit) {
            case KEY: {
                collector.emit((Object)key, (Object)key);
                break;
            }
            case ENTITY: {
                collector.emit((Object)key, (Object)e);
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY;

    }
}

