/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.models.sessions.infinispan.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientInitialAccessPredicate
implements Predicate<Map.Entry<String, SessionEntity>>,
Serializable {
    private String realm;
    private Integer expired;

    public ClientInitialAccessPredicate(String realm) {
        this.realm = realm;
    }

    public static ClientInitialAccessPredicate create(String realm) {
        return new ClientInitialAccessPredicate(realm);
    }

    public ClientInitialAccessPredicate expired(int time) {
        this.expired = time;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntity> entry) {
        SessionEntity e = entry.getValue();
        if (!this.realm.equals(e.getRealm())) {
            return false;
        }
        if (!(e instanceof ClientInitialAccessEntity)) {
            return false;
        }
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)e;
        if (this.expired != null) {
            if (entity.getRemainingCount() <= 0) {
                return true;
            }
            return entity.getExpiration() > 0 && entity.getTimestamp() + entity.getExpiration() < this.expired;
        }
        return true;
    }
}

