/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission.evaluator;

import java.util.List;
import java.util.concurrent.Executor;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.IterablePermissionEvaluator;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.permission.evaluator.ScheduledPermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;

public final class Evaluators {
    private final DefaultPolicyEvaluator policyEvaluator;
    private final Executor scheduler;

    public Evaluators(DefaultPolicyEvaluator policyEvaluator, Executor scheduler) {
        this.policyEvaluator = policyEvaluator;
        this.scheduler = scheduler;
    }

    public PermissionEvaluator from(List<ResourcePermission> permissions, EvaluationContext evaluationContext) {
        return this.schedule(permissions, evaluationContext);
    }

    public PermissionEvaluator schedule(List<ResourcePermission> permissions, EvaluationContext evaluationContext) {
        return new ScheduledPermissionEvaluator(new IterablePermissionEvaluator(permissions.iterator(), evaluationContext, this.policyEvaluator), this.scheduler);
    }
}

