/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;

public class StripSecretsUtils {
    public static ComponentRepresentation strip(KeycloakSession session, ComponentRepresentation rep) {
        Map<String, ProviderConfigProperty> configProperties = ComponentUtil.getComponentConfigProperties(session, rep);
        if (rep.getConfig() == null) {
            return rep;
        }
        Iterator itr = rep.getConfig().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry next = (Map.Entry)itr.next();
            ProviderConfigProperty configProperty = configProperties.get(next.getKey());
            if (configProperty != null) {
                if (!configProperty.isSecret()) continue;
                next.setValue(Collections.singletonList("**********"));
                continue;
            }
            itr.remove();
        }
        return rep;
    }

    public static RealmRepresentation strip(RealmRepresentation rep) {
        if (rep.getSmtpServer() != null && rep.getSmtpServer().containsKey("password")) {
            rep.getSmtpServer().put("password", "**********");
        }
        return rep;
    }

    public static IdentityProviderRepresentation strip(IdentityProviderRepresentation rep) {
        if (rep.getConfig() != null && rep.getConfig().containsKey("clientSecret")) {
            rep.getConfig().put("clientSecret", "**********");
        }
        return rep;
    }
}

