/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLSubjectParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StaxParserUtil.getNextEvent(xmlEventReader);
        SubjectType subject = new SubjectType();
        while (xmlEventReader.hasNext()) {
            SubjectType.STSubType subType;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT.get())) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName(endElement));
            }
            StartElement peekedElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName(peekedElement);
            if (JBossSAMLConstants.NAMEID.get().equalsIgnoreCase(tag)) {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.addBaseID((BaseIDAbstractType)nameID);
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                throw new ParsingException("PL00069: Parser: Type not supported:" + JBossSAMLConstants.BASEID.get());
            }
            if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.setEncryptedID(new EncryptedElementType(domElement));
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_CONFIRMATION.get().equalsIgnoreCase(tag)) {
                StartElement subjectConfirmationElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                Attribute method = subjectConfirmationElement.getAttributeByName(new QName(JBossSAMLConstants.METHOD.get()));
                SubjectConfirmationType subjectConfirmationType = new SubjectConfirmationType();
                if (method != null) {
                    subjectConfirmationType.setMethod(StaxParserUtil.getAttributeValue(method));
                }
                xmlEvent = StaxParserUtil.peek(xmlEventReader);
                while (xmlEventReader.hasNext()) {
                    xmlEvent = StaxParserUtil.peek(xmlEventReader);
                    if (xmlEvent instanceof EndElement) {
                        EndElement endElement = (EndElement)xmlEvent;
                        if (StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION.get())) {
                            StaxParserUtil.getNextEndElement(xmlEventReader);
                            break;
                        }
                        throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName(endElement));
                    }
                    peekedElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    if (peekedElement == null) break;
                    String startTag = StaxParserUtil.getStartElementName(peekedElement);
                    if (startTag.equals(JBossSAMLConstants.NAMEID.get())) {
                        NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                        subjectConfirmationType.setNameID(nameID);
                        continue;
                    }
                    if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                        throw logger.unsupportedType(JBossSAMLConstants.BASEID.get());
                    }
                    if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                        Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                        subjectConfirmationType.setEncryptedID(new EncryptedElementType(domElement));
                        continue;
                    }
                    if (!startTag.equals(JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get())) continue;
                    SubjectConfirmationDataType subjectConfirmationData = this.parseSubjectConfirmationData(xmlEventReader);
                    subjectConfirmationType.setSubjectConfirmationData(subjectConfirmationData);
                }
                subject.addConfirmation(subjectConfirmationType);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return subject;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.SUBJECT.get());
    }

    private SubjectConfirmationDataType parseSubjectConfirmationData(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Attribute address;
        Attribute recipient;
        Attribute notOnOrAfter;
        Attribute notBefore;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        Attribute inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()));
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(StaxParserUtil.getAttributeValue(inResponseTo));
        }
        if ((notBefore = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_BEFORE.get()))) != null) {
            subjectConfirmationData.setNotBefore(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notBefore)));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notOnOrAfter)));
        }
        if ((recipient = startElement.getAttributeByName(new QName(JBossSAMLConstants.RECIPIENT.get()))) != null) {
            subjectConfirmationData.setRecipient(StaxParserUtil.getAttributeValue(recipient));
        }
        if ((address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()))) != null) {
            subjectConfirmationData.setAddress(StaxParserUtil.getAttributeValue(address));
        }
        if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement)) {
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("KeyInfo")) {
                KeyInfoType keyInfo = SAMLParserUtil.parseKeyInfo(xmlEventReader);
                subjectConfirmationData.setAnyType((Object)keyInfo);
            } else if (tag.equals("EncryptedKey")) {
                subjectConfirmationData.setAnyType((Object)StaxParserUtil.getDOMElement(xmlEventReader));
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
        }
        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
        StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        return subjectConfirmationData;
    }
}

