/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.supplier;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionSupplier;

public class PostgresqlConnSupplier
extends ConnectionSupplier {
    @Override
    public String getDatabaseShortName() {
        return "postgresql";
    }

    @Override
    public String getAdminUsername() {
        return "postgres";
    }

    public String getInstallDir() {
        return "C:\\pgsql-" + this.getShortVersion();
    }

    @Override
    public String getVersion() {
        String version = super.getVersion();
        if (version == null) {
            return "9.3.2-3";
        }
        return version;
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getIpAddress() + "/" + this.getPrimaryCatalog();
    }

    @Override
    public Set<String> getPuppetModules() {
        Set<String> modules = super.getPuppetModules();
        modules.add("puppetlabs/postgresql");
        return modules;
    }

    @Override
    public ConnectionSupplier.ConfigTemplate getPuppetTemplate(Map<String, Object> context) {
        if (this.isWindows()) {
            return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/postgresql/postgresql-windows.puppet.vm", context);
        }
        return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/postgresql/postgresql-linux.puppet.vm", context);
    }

    @Override
    public Set<ConnectionSupplier.ConfigTemplate> generateConfigFiles(Map<String, Object> context) throws IOException {
        Set<ConnectionSupplier.ConfigTemplate> configTemplates = super.generateConfigFiles(context);
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/postgresql/postgresql.init.sql.vm", context));
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/postgresql/postgresql.conf.vm", context));
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/postgresql/pg_hba.conf.vm", context));
        return configTemplates;
    }

    @Override
    public String getDescription() {
        if (this.isWindows()) {
            return super.getDescription() + "\n" + "Install Dir: " + this.getInstallDir() + "\n" + "REQUIRES: LIQUIBASE_HOME/sdk/vagrant/install-files/windows/vcredist_64.exe. Download Microsoft Visual C++ 2010 Redistributable Package (x64) from http://www.microsoft.com/en-us/download/confirmation.aspx?id=14632\n" + "REQUIRES: LIQUIBASE_HOME/sdk/vagrant/install-files/postgresql/postgresql-" + this.getVersion() + "-windows-x64-binaries.zip. Download Win x86-64 archive from http://www.enterprisedb.com/products-services-training/pgbindownload\n" + "Admin 'postgres' user password: " + this.getAdminPassword();
        }
        return super.getDescription();
    }
}

