/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.change.core.AlterSequenceChange;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Sequence;

public class ChangedSequenceChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Sequence.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        AlterSequenceChange change;
        Sequence sequence = (Sequence)changedObject;
        ArrayList<AlterSequenceChange> changes = new ArrayList<AlterSequenceChange>();
        if (differences.isDifferent("incrementBy")) {
            change = this.createAlterSequenceChange(sequence, control);
            change.setIncrementBy(sequence.getIncrementBy());
            changes.add(change);
        }
        if (differences.isDifferent("maxValue")) {
            change = this.createAlterSequenceChange(sequence, control);
            change.setMaxValue(sequence.getMaxValue());
            changes.add(change);
        }
        if (differences.isDifferent("ordered")) {
            change = this.createAlterSequenceChange(sequence, control);
            change.setOrdered(sequence.getOrdered());
            changes.add(change);
        }
        if (differences.isDifferent("cacheSize")) {
            change = this.createAlterSequenceChange(sequence, control);
            change.setCacheSize(sequence.getCacheSize());
            changes.add(change);
        }
        if (differences.isDifferent("willCycle")) {
            change = this.createAlterSequenceChange(sequence, control);
            change.setWillCycle(sequence.getWillCycle());
            changes.add(change);
        }
        if (changes.size() == 0) {
            return null;
        }
        return changes.toArray(new Change[changes.size()]);
    }

    protected AlterSequenceChange createAlterSequenceChange(Sequence sequence, DiffOutputControl control) {
        AlterSequenceChange change = new AlterSequenceChange();
        if (control.getIncludeCatalog()) {
            change.setCatalogName(sequence.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(sequence.getSchema().getName());
        }
        change.setSequenceName(sequence.getName());
        return change;
    }
}

