/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.operator;

import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.operator.ControlOperatorParser;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.util.FileLister;

public class RedirectionCompletion
implements Completion {
    @Override
    public void complete(CompleteOperation completeOperation) {
        if (ControlOperatorParser.doStringContainRedirectionNoPipeline(completeOperation.getBuffer())) {
            int redirectPos = ControlOperatorParser.findLastRedirectionPositionBeforeCursor(completeOperation.getBuffer(), completeOperation.getCursor());
            String word = Parser.findCurrentWordFromCursor(completeOperation.getBuffer().substring(redirectPos, completeOperation.getCursor()), completeOperation.getCursor() - redirectPos);
            completeOperation.setOffset(completeOperation.getCursor());
            FileLister lister = new FileLister(word, completeOperation.getAeshContext().getCurrentWorkingDirectory());
            lister.findMatchingDirectories(completeOperation);
            if (completeOperation.getCompletionCandidates().size() > 1) {
                completeOperation.removeEscapedSpacesFromCompletionCandidates();
            }
            completeOperation.setIgnoreStartsWith(true);
        }
    }
}

