/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.common.ResourceProvider;
import org.drools.core.util.ClassUtils;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.internal.utils.ClassLoaderResolver;
import org.kie.internal.utils.NoDepsClassLoaderResolver;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(KieModuleKieProject.class);
    private List<InternalKieModule> kieModules;
    private Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private InternalKieModule kieModule;
    private ProjectClassLoader cl;

    public KieModuleKieProject(InternalKieModule kieModule) {
        this(kieModule, null);
    }

    public KieModuleKieProject(InternalKieModule kieModule, ClassLoader parent) {
        this.kieModule = kieModule;
        if (parent == null) {
            ClassLoaderResolver resolver;
            try {
                resolver = (ClassLoaderResolver)ServiceRegistryImpl.getInstance().get(ClassLoaderResolver.class);
            }
            catch (Exception cne) {
                resolver = new NoDepsClassLoaderResolver();
            }
            parent = resolver.getClassLoader((KieModule)kieModule);
        }
        this.cl = ProjectClassLoader.createProjectClassLoader((ClassLoader)parent, (ResourceProvider)kieModule.createResourceProvider());
    }

    @Override
    public void init() {
        if (this.kieModules == null) {
            this.kieModules = new ArrayList<InternalKieModule>();
            this.kieModules.addAll(this.kieModule.getKieDependencies().values());
            this.kieModules.add(this.kieModule);
            this.indexParts(this.kieModules, this.kJarFromKBaseName);
            this.initClassLoader(this.cl);
        }
    }

    private void initClassLoader(ProjectClassLoader projectCL) {
        for (Map.Entry<String, byte[]> entry : this.getClassesMap().entrySet()) {
            if (entry.getValue() == null) continue;
            String resourceName = entry.getKey();
            String className = ClassUtils.convertResourceToClassName((String)resourceName);
            projectCL.storeClass(className, resourceName, entry.getValue());
        }
    }

    private Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (InternalKieModule kModule : this.kieModules) {
            classes.putAll(kModule.getClassesMap(kModule != this.kieModule));
        }
        return classes;
    }

    @Override
    public InputStream getPomAsStream() {
        return this.kieModule.getPomAsStream();
    }

    @Override
    public ReleaseId getGAV() {
        return this.kieModule.getReleaseId();
    }

    @Override
    public long getCreationTimestamp() {
        return this.kieModule.getCreationTimestamp();
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    public InternalKieModule getInternalKieModule() {
        return this.kieModule;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @Override
    public ClassLoader getClonedClassLoader() {
        ProjectClassLoader clonedCL = ProjectClassLoader.createProjectClassLoader((ClassLoader)this.cl.getParent(), (ResourceProvider)this.kieModule.createResourceProvider());
        this.initClassLoader(clonedCL);
        return clonedCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToModule(InternalKieModule updatedKieModule) {
        this.kieModules = null;
        this.kJarFromKBaseName.clear();
        ReleaseId currentReleaseId = this.kieModule.getReleaseId();
        ReleaseId updatingReleaseId = updatedKieModule.getReleaseId();
        if (currentReleaseId.getGroupId().equals(updatingReleaseId.getGroupId()) && currentReleaseId.getArtifactId().equals(updatingReleaseId.getArtifactId())) {
            this.kieModule = updatedKieModule;
        } else if (this.kieModule.getKieDependencies().keySet().contains(updatingReleaseId)) {
            this.kieModule.addKieDependency(updatedKieModule);
        }
        KieModuleKieProject kieModuleKieProject = this;
        synchronized (kieModuleKieProject) {
            this.cleanIndex();
            this.init();
        }
    }

    @Override
    public synchronized KieBaseModel getDefaultKieBaseModel() {
        return super.getDefaultKieBaseModel();
    }

    @Override
    public synchronized KieSessionModel getDefaultKieSession() {
        return super.getDefaultKieSession();
    }

    @Override
    public synchronized KieSessionModel getDefaultStatelessKieSession() {
        return super.getDefaultStatelessKieSession();
    }

    @Override
    public synchronized KieBaseModel getKieBaseModel(String kBaseName) {
        return super.getKieBaseModel(kBaseName);
    }

    @Override
    public synchronized KieSessionModel getKieSessionModel(String kSessionName) {
        return super.getKieSessionModel(kSessionName);
    }
}

