/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.jaxb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kie.internal.jaxb.StringKeyObjectValueEntry;
import org.kie.internal.jaxb.StringKeyObjectValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringKeyObjectValueMapXmlAdapter
extends XmlAdapter<StringKeyObjectValueMap, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(StringKeyObjectValueMapXmlAdapter.class);

    public StringKeyObjectValueMap marshal(Map<String, Object> map) throws Exception {
        if (map == null) {
            return null;
        }
        StringKeyObjectValueMap xmlMap = new StringKeyObjectValueMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            StringKeyObjectValueEntry xmlEntry = StringKeyObjectValueMapXmlAdapter.createJaxbStringObjectMapEntry(value, key);
            xmlMap.addEntry(xmlEntry);
        }
        return xmlMap;
    }

    static StringKeyObjectValueEntry createJaxbStringObjectMapEntry(Object value, String key) {
        byte[] content = null;
        String className = null;
        if (value != null) {
            className = value.getClass().getName();
            content = StringKeyObjectValueMapXmlAdapter.serializeObject(value, key);
        }
        return new StringKeyObjectValueEntry(key, className, content);
    }

    public static byte[] serializeObject(Object obj, String key) {
        Class<?> valueClass = obj.getClass();
        if (valueClass.getCanonicalName() == null) {
            logger.error("Unable to serialize '" + key + "' " + "because serialization of weird classes is not supported: " + valueClass.getName());
            return null;
        }
        if (!(obj instanceof Serializable)) {
            logger.error("Unable to serialize '" + key + "' " + "because " + valueClass.getName() + " is an unserializable class");
            return null;
        }
        byte[] serializedBytes = null;
        try {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bais);
            out.writeObject(obj);
            serializedBytes = bais.toByteArray();
        }
        catch (IOException ioe) {
            logger.error("Unable to serialize '" + key + "' " + "because of exception: " + ioe.getMessage(), (Throwable)ioe);
            return null;
        }
        return serializedBytes;
    }

    public Map<String, Object> unmarshal(StringKeyObjectValueMap xmlMap) {
        if (xmlMap == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (StringKeyObjectValueEntry xmlEntry : xmlMap.entries) {
            String key = xmlEntry.getKey();
            Object value = StringKeyObjectValueMapXmlAdapter.deserializeObject(xmlEntry.getBytes(), xmlEntry.getClassName(), key);
            map.put(key, value);
        }
        return map;
    }

    public static Object deserializeObject(byte[] objBytes, String className, String key) {
        Object value;
        if (objBytes == null || objBytes.length == 0) {
            return null;
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Unable to deserialize '" + key + "' " + "because " + className + " is not on the classpath.", (Throwable)cnfe);
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objBytes);
        try {
            ObjectInputStream input = new ObjectInputStream(bais);
            value = input.readObject();
        }
        catch (IOException ioe) {
            logger.error("Unable to deserialize '" + key + "' because of exception: " + ioe.getMessage(), (Throwable)ioe);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Unable to deserialize '" + key + "' because " + className + " is not on the classpath.", (Throwable)cnfe);
            return null;
        }
        return value;
    }
}

